'use strict';
define(function() {
  var grilleConformite = function(FeatureTypeFactory, $timeout, $rootScope) {
    return {
      templateUrl: function(elem, attrs) {
        if (attrs.pananc === 'true') {
          return 'js/XG/widgets/ancapp/main/views/directives/grille_conformite_pananc.html';
        } else {
          return 'js/XG/widgets/ancapp/main/views/directives/grille_conformite.html';
        }
      },
      restrict: 'EA',
      scope: {
        cdata: '=',
        controleCommentConfig: '=?',
        currentReport: '=?',
        clos: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.kis_anc_listes_deroulantes_controles = FeatureTypeFactory.getFeatureByUid(
          'kis_anc_listes_deroulantes_controles'
        );

        //pour le grille de conformite pananc
        scope.uncheckenjeuenv = function() {
          if (scope.cdata.grille.conc.enjeu === '0') {
            scope.cdata.grille.conc.enjeusan = '0';
            scope.cdata.grille.conc.enjeuenv = '0';
          }
        };

        scope.checkjeuOrenv = function() {
          if (
            scope.cdata.grille.conc.enjeusan === '1' ||
            scope.cdata.grille.conc.enjeuenv === '1'
          ) {
            scope.cdata.grille.conc.enjeu = '1';
          }
        };

        scope.checkpaspb = function() {
          if (
            angular.isDefined(scope.cdata.grille) &&
            angular.isDefined(scope.cdata.grille.conc) &&
            scope.cdata.grille.conc.paspb === '1'
          ) {
            if (angular.isDefined(scope.cdata.grille.installation)) {
              scope.cdata.grille.installation.absent = '0';
            }
            if (angular.isDefined(scope.cdata.grille.defaut_structure)) {
              scope.cdata.grille.defaut_structure.securite_sanitaire = '0';
              scope.cdata.grille.defaut_structure.structure_fermeture = '0';
              scope.cdata.grille.defaut_structure.proximite_puits = '0';
            }
            if (angular.isDefined(scope.cdata.grille.dysfonctionnement)) {
              scope.cdata.grille.dysfonctionnement.installation_incomplete =
                '0';
              scope.cdata.grille.dysfonctionnement.sous_dimensionnee = '0';
              scope.cdata.grille.dysfonctionnement.majeur = '0';
            }
            if (angular.isDefined(scope.cdata.grille.entretien_usure)) {
              scope.cdata.grille.entretien_usure.show_article = 0;
            }
          }
        };

        scope.checkpb = function() {
          if (
            angular.isDefined(scope.cdata.grille) &&
            ((angular.isDefined(scope.cdata.grille.installation) &&
              scope.cdata.grille.installation.absent === '1') ||
              (angular.isDefined(scope.cdata.grille.defaut_structure) &&
                (scope.cdata.grille.defaut_structure.securite_sanitaire ===
                  '1' ||
                  scope.cdata.grille.defaut_structure.structure_fermeture ===
                    '1' ||
                  scope.cdata.grille.defaut_structure.proximite_puits ===
                    '1')) ||
              (angular.isDefined(scope.cdata.grille.dysfonctionnement) &&
                (scope.cdata.grille.dysfonctionnement
                  .installation_incomplete === '1' ||
                  scope.cdata.grille.dysfonctionnement.sous_dimensionnee ===
                    '1' ||
                  scope.cdata.grille.dysfonctionnement.majeur === '1')) ||
              (angular.isDefined(scope.cdata.grille.entretien_usure) &&
                scope.cdata.grille.entretien_usure.show_article === 1))
          ) {
            if (angular.isDefined(scope.cdata.grille.conc)) {
              scope.cdata.grille.conc.paspb = '0';
            }
          }
        };

        //for clasic grille of conformity
        scope.setGrilleConformite = init => {
          if (
            angular.isDefined(scope.cdata.grille) &&
            Object.keys(scope.cdata.grille).length > 0
          ) {
            Object.keys(scope.cdata.grille).forEach(function(attr) {
              if (
                isObject(scope.cdata.grille[attr]) &&
                Object.keys(scope.cdata.grille[attr]).length > 0
              )
                Object.keys(scope.cdata.grille[attr]).forEach(function(attr2) {
                  if (scope.cdata.grille[attr][attr2] != null)
                    scope.checkConformite(attr + '.' + attr2);
                  return;
                });
            });
          }

          if (init) {
            if (!scope.cdata.grille) {
              scope.cdata.grille = {
                conc: {},
              };
            }
            if (
              scope.currentReport.properties.enjeusan !== undefined &&
              scope.cdata.grille.conc.enjeusan === undefined
            ) {
              scope.cdata.grille.conc.enjeusan =
                "'" +
                parseInt(scope.currentReport.properties.enjeusan, 10) +
                "'";
            }
            if (
              scope.currentReport.properties.enjeuenv !== undefined &&
              scope.cdata.grille.conc.enjeuenv === undefined
            ) {
              scope.cdata.grille.conc.enjeuenv =
                "'" +
                parseInt(scope.currentReport.properties.enjeuenv, 10) +
                "'";
            }
            $rootScope.$broadcast(
              'updateCleanData',
              scope.cdata.grille,
              'checkDiffCdata.grille'
            );
          }
        };

        const isObject = value => {
          return value && typeof value === 'object';
        };

        scope.checkConformite = value => {
          $timeout(function() {
            const firstKey = value.split('.')[0];
            const secondKey = value.split('.')[1];
            if (
              firstKey === 'installation' &&
              secondKey === 'present' &&
              scope.cdata.grille[firstKey][secondKey] === '1'
            ) {
              scope.cdata.grille[firstKey].absent = '0';
            } else if (
              firstKey === 'installation' &&
              secondKey === 'absent' &&
              scope.cdata.grille[firstKey][secondKey] === '1'
            ) {
              scope.cdata.grille[firstKey].present = '0';
            }

            if (
              secondKey === 'aucun_defaut' &&
              scope.cdata.grille[firstKey][secondKey] === '1'
            ) {
              // register comantaire
              let newObj = {};
              if (angular.isDefined(scope.cdata.grille[firstKey].commentaire)) {
                newObj.commentaire = scope.cdata.grille[firstKey].commentaire;
              }

              scope.cdata.grille[firstKey] = newObj;
              scope.cdata.grille[firstKey][secondKey] = '1';
              scope.cdata.grille[firstKey].show_article = 0;
            } else {
              if (
                angular.isUndefined(
                  scope.cdata.grille[firstKey].aucun_defaut
                ) ||
                scope.cdata.grille[firstKey].aucun_defaut === null
              )
                scope.cdata.grille[firstKey].aucun_defaut = '0';
              const propKeys = Object.keys(scope.cdata.grille[firstKey]).filter(
                function(item) {
                  return (
                    scope.cdata.grille[firstKey][item] == '1' &&
                    item !== 'aucun_defaut' &&
                    item !== 'show_article' &&
                    item !== 'present'
                  );
                }
              );
              if (propKeys.length) {
                scope.cdata.grille[firstKey].show_article = 1;
              } else {
                scope.cdata.grille[firstKey].show_article = 0;
              }
            }

            testIsConforme();
          }, 0);
        };

        const testIsConforme = () => {
          if (angular.isDefined(scope.showConforme)) delete scope.showConforme;

          // Ajout du showArticle s'il est manquant,
          // permettant l'affichage de la non conformité du contrôle
          for(const category in scope.cdata.grille) {
            // Si on est dans un des cas pouvant entrainer la non conformité du controle
            if(isObject(scope.cdata.grille[category]) && category !== 'conc') {
              for (const checkBox in scope.cdata.grille[category]) {
                if(checkBox !== 'aucun_defaut' && checkBox !== 'present' && scope.cdata.grille[category][checkBox] === '1'){
                  scope.cdata.grille[category].show_article = 1;
                }
              }
            }
          }

          let hasArticle = Object.keys(scope.cdata.grille).filter(key => {
            return (
              key !== 'entretien_usure' &&
              key !== 'conc' &&
              isObject(scope.cdata.grille[key]) &&
              scope.cdata.grille[key].show_article === 1
            );
          });

          if (
            angular.isDefined(scope.cdata.grille.installation) &&
            scope.cdata.grille.installation.absent === '1'
          )
            hasArticle.push(scope.cdata.grille.installation.absent);

          let hasAucunDefaut = Object.keys(scope.cdata.grille).filter(
            defaut => {
              return scope.cdata.grille[defaut].aucun_defaut === '1';
            }
          );

          if (
            angular.isDefined(scope.cdata.grille.installation) &&
            scope.cdata.grille.installation.present === '1'
          )
            hasAucunDefaut.push(scope.cdata.grille.installation.present);

          if (hasArticle.length) {
            scope.showConforme = 'avis_non_conforme';
            scope.cdata.grille.conclusion = 'Avis non conforme.';
          } else if (!hasArticle.length && hasAucunDefaut.length) {
            scope.showConforme = 'avis_conforme';
            scope.cdata.grille.conclusion = 'Avis conforme.';
          } else {
            scope.showConforme = '';
          }
        };
        //à l'ouverture du formulaire -> calculer la conformité
        testIsConforme();
      },
    };
  };

  grilleConformite.$inject = ['FeatureTypeFactory', '$timeout', '$rootScope'];
  return grilleConformite;
});
