'use strict';

/**
 * @ngdoc controller
 * @name modules.authentication.controller:RestrictionCtrl
 * @description
 * The RestrictionCtrl controller
 */
define(function() {
  var RestrictionCtrl = function(
    $scope,
    ngDialog,
    RestrictionFactory,
    $timeout,
    FeatureTypeFactory,
    gcWMS,
    $filter,
    $rootScope,
    DataStoreFactory
  ) {
    let mapSrid = 'EPSG:3857';



    /**
     * Fonction déplacé, elle était en fin de code.
     * Rôle: Ajouter les couches sur la carte en mode invisible.
     */
    const initialiseLayers = () => {
      $scope.Layers = new ol.Collection();
      if ($scope.selection.ftis && $scope.selection.ftis.length > 0)
        $scope.selection.ftis.map((x, i) => {
          if (angular.isUndefined(x.index)) {
            x.index = i;
          }
          const l = gcWMS.getOlLayerFromFeaturetypeInfo(x);
          if (angular.isUndefined(l.index)) l.index = i;
          l.setVisible(false);
          l.selectionable = false;
          $scope.Layers.insertAt(l.index, l);
          $scope.map.addLayer(l);
        });
    };


    /**
     * Création de la carte OpenLayers associée à la DIV "rf_map" .
     */
    const defineMap = () => {
      const osm = new ol.layer.Tile({ source: new ol.source.OSM() });

      if ($scope.currentRestrictionRessource
        && $scope.currentRestrictionRessource.geomSrid) {
        //-- Ouverture en mode mise à jour: on récupére le SRID
        //-- du contour de restriction.
        mapSrid = $scope.currentRestrictionRessource.geomSrid;
      }
      $scope.map = new ol.Map({
        target: 'rf_map',
        layers: [osm],
        controls: ol.control
          .defaults({
            attribution: false,
            rotate: true,
            zoomOptions: {
              zoomInLabel: '+',
              zoomOutLabel: '-',
              zoomInTipLabel: '',
              zoomOutTipLabel: '',
            },
          })
          .extend([
            new ol.control.ScaleLine(),
          ]),
        interactions: ol.interaction
          .defaults({
            altShiftDragRotate: true,
            touchRotate: false,
            keyboard: false,
          })
          .extend([new ol.interaction.DragZoom()]),
        renderer: 'canvas',
        view: new ol.View({
          projection: mapSrid,
          center: [213606.73842054035, 5869644.498443234],
          minResolution: 0.03732276771737122,
          zoom: 6,
        }),
      });

      initialiseLayers();
    };


    /**
     * Récupération du nom des sources de données du portail.
     */
    const getDataStore = () => {
      if ($rootScope.xgos && $rootScope.xgos.portal) {
        DataStoreFactory.get().then((res) => {
          $scope.storeNames = res.data.map((x) => {
            return x.name;
          })
            .filter((x) => {
              if (x) return x;
            });
        });
      }
      else {
        $timeout(getDataStore, 800);
      }
    };

    getDataStore();

    RestrictionFactory.getAllRestrictions().then(
      function(res) {
        if (res.data) {
          $scope.currentResources = res.data;
          RestrictionFactory.setRestriction(res.data);
        } else {
          console.info('no config');
        }
      },
      function() {
        console.info('no config');
      }
    );

    RestrictionFactory.getDatastore().then(
      function(res) {
        if (res.data.etat === 'fini') {
          $scope.datastore = res.data.data.name;
        } else {
          console.info('no config');
        }
      },
      function() {
        console.info('no config');
      }
    );

    $scope.addorUpdateDataSource = function() {
      $scope.dialogdatastore = ngDialog.open({
        template:
          'js/XG/modules/rights/views/modals/modal.restriction_datasource.html',
        className: 'ngdialog-theme-plain width500',
        closeByDocument: false,
        scope: $scope,
      });
    };

    $scope.selection = {
      selectedftis: [],
      ftis: [],
    };
    FeatureTypeFactory.get().then(
      function() {
        $scope.ftis = FeatureTypeFactory.resources.featuretypes
          .map(function(x) {
            if (x.typeInfo.toLowerCase() === 'polygon') {
              return x;
            }
          })
          .filter(function(x) {
            if (x) return x;
          });
      },
      function(res) {
        console.error(res.data.message);
        require('toastr').error(res.data.message);
      }
    );

    $scope.addRestriction = function() {
      if (!$scope.datastore) {
        var ans = confirm(
          $filter('translate')('rights.restriction.choosedatasource')
        );
        if (ans) $scope.addorUpdateDataSource();
      } else {
        $scope.restrictionNames = $scope.currentResources.map(function(x) {
          return x.name;
        });

        $scope.map = undefined;
        $scope.editMode = 'add';
        $scope.edit_resource = {
          id: Math.floor(Math.random() * 1000000),
          modes: {},
        };

        $scope.currentRestrictionRessource = angular.copy($scope.edit_resource);
        if (!$scope.currentRestrictionRessource.ftis)
          $scope.currentRestrictionRessource.ftis = [];
        if (!$scope.selection.ftis) $scope.selection.ftis = [];
        $scope.selection.ftis = $scope.ftis
          .map(function(x) {
            if ($scope.currentRestrictionRessource.ftis.indexOf(x.uid) !== -1)
              return x;
          })
          .filter(function(x) {
            if (x) return x;
          });
        $scope.dialog = ngDialog.open({
          template:
            'js/XG/modules/rights/views/modals/modal.restriction_maps.html',
          className: 'ngdialog-theme-plain width1000',
          closeByDocument: false,
          scope: $scope,
        });
        $timeout(defineMap, 500);
      }
    };

    $scope.updateRestriction = function() {
      $scope.restrictionNames = $scope.currentResources.map(function(x) {
        return x.name;
      });
      $scope.map = undefined;
      $scope.editMode = 'update';
      $scope.currentRestrictionRessource = angular.copy($scope.edit_resource);
      if (!$scope.currentRestrictionRessource.ftis)
        $scope.currentRestrictionRessource.ftis = [];
      if (!$scope.selection.ftis) $scope.selection.ftis = [];
      $scope.selection.ftis = $scope.ftis
        .map(function(x) {
          if ($scope.currentRestrictionRessource.ftis.indexOf(x.uid) !== -1)
            return x;
        })
        .filter(function(x) {
          if (x) return x;
        });
      $scope.dialog = ngDialog.open({
        template:
          'js/XG/modules/rights/views/modals/modal.restriction_maps.html',
        className: 'ngdialog-theme-plain width1000',
        closeByDocument: false,
        scope: $scope,
      });
      $timeout(defineMap, 500);
    };

    $scope.removeRestriction = function() {
      RestrictionFactory.removeRestriction(
        $scope.currentResources[$scope.selected_resource_index]
      ).then(
        (res) => {
          if (res.data === true) {
            console.info('suppression success');
            $scope.currentResources.splice($scope.selected_resource_index, 1);
          } else {
            console.info('suppression fail');
          }
        },
        (res) => {
          console.error(res.data.message);
        }
      );
    };

    $scope.addRestrictionInList = function(currentRestrictionRessource) {
      if (angular.isUndefined($scope.currentResources))
        $scope.currentResources = [];

      if (
        ($scope.restrictionNames.indexOf(currentRestrictionRessource.name) !==
          -1 &&
          $scope.editMode === 'add') ||
        ($scope.edit_resource.name !== currentRestrictionRessource.name &&
          $scope.restrictionNames.indexOf(currentRestrictionRessource.name) !==
            -1 &&
          $scope.editMode === 'update')
      ) {
        require('toastr').error(
          $filter('translate')('rights.restriction.differentName')
        );
        return false;
      }

      if (currentRestrictionRessource.geometry) {
        currentRestrictionRessource.geomSrid = mapSrid;
        if (
          !currentRestrictionRessource.modes.userchoice &&
          !currentRestrictionRessource.modes.edition &&
          !currentRestrictionRessource.modes.query &&
          !currentRestrictionRessource.modes.viewer
        ) {
          currentRestrictionRessource.modes.userchoice = true;
        }

        currentRestrictionRessource.ftis
          = $scope.selection.ftis.map(x => x.uid);
        switch ($scope.editMode) {
          case 'add':
            RestrictionFactory.addRestriction(currentRestrictionRessource).then(
              function(res) {
                if (res.data) {
                  $scope.currentResources.push(res.data);
                  $scope.dialog.close();
                } else {
                  require('toastr').error(
                    $filter('translate')(
                      'rights.restriction.erreurenregistrement'
                    )
                  );
                }
              },
              function(res) {
                console.error(res.data.message);
                require('toastr').error(
                  $filter('translate')(
                    'rights.restriction.erreurenregistrement'
                  )
                );
              }
            );
            break;
          case 'update':
            RestrictionFactory.updateRestriction(
              currentRestrictionRessource
            ).then(
              function(res) {
                if (res.data) {
                  for (var i = 0; i < $scope.currentResources.length; i++) {
                    if (
                      $scope.currentResources[i].id ===
                      currentRestrictionRessource.id
                    ) {
                      $scope.currentResources[i] = angular.copy(
                        currentRestrictionRessource
                      );
                      break;
                    }
                  }
                  $scope.dialog.close();
                } else {
                  require('toastr').error(
                    $filter('translate')(
                      'rights.restriction.erreurenregistrement'
                    )
                  );
                }
              },
              function(res) {
                console.error(res.data.message);
                require('toastr').error(
                  $filter('translate')(
                    'rights.restriction.erreurenregistrement'
                  )
                );
              }
            );
            break;
        }
        return true;
      } else {
        require('toastr').error(
          $filter('translate')('rights.restriction.map.chooseGeometryatleast')
        );
        return false;
      }
    };

    $scope.refreshDocumentsList = function() {
      refreshList();
    };

    $scope.editListCfg = {
      dataModule: 'rights',
      resource_type: 'restriction',
      cols: ['name', 'description', 'uid'],
      addFunction: $scope.addRestriction,
      editFunction: $scope.updateRestriction,
      removeFunction: $scope.removeRestriction,
    };

    /**
     * [refreshList description]
     * @return {[type]} [description]
     */
    const refreshList = () => {
      $scope.currentResources = [];
      RestrictionFactory.getAllRestrictions().then(
        function(res) {
          if (res.data) {
            $scope.currentResources = res.data;
          } else {
            console.info('no config');
          }
        },
        function() {
          console.info('no config');
        }
      );
    };

    $scope.changedViewer = function(modes) {
      modes.edition = true;
      modes.query = true;
    };

    $scope.changedForUser = function(modes) {
      if (modes.userchoice) {
        modes.edition = false;
        modes.query = false;
        modes.viewer = false;
      }
    };


    /**
     * Dans le cas ArcGIS, on va travailler avec le même système de projection
     * que celui des données pour garder une bonne précision.
     * Donc on réinitialise la carte dans le cas où on ajoute le premier layer
     * dans la carte et que ce layer est un mlayer ESRI.
     *
     * @param {*} fti : fti du layer en cours d'ajout
     */
    const checkMapSrid = (fti) => {
      if ($scope.Layers.getLength() === 0 && fti.type === 'esri') {

        if ($scope.currentRestrictionRessource
          && mapSrid === $scope.currentRestrictionRessource.geomSrid
          && $scope.map) {
          //-- La map est définié et a le même SRID, donc, donc,
          //-- pas besoin de la recréer.
          return;
        }

        mapSrid = fti.srid;
        const mapElt = document.getElementById('rf_map');
        let child = mapElt.lastElementChild;
        while (child) {
          mapElt.removeChild(child);
          child = mapElt.lastElementChild;
        }
        defineMap();
        $rootScope.$broadcast('retrictionMapChanged',
          { map: $scope.map, mapSrid: mapSrid });
      }
    };


    /**
     * Ajout d'un layer dans la carte pour sélection d'un contour
     * de restriction appartenant à ce layer.
     */
    $scope.addToGeocatalogue = () => {
      if (!angular.element('#collapse-target-restriction').hasClass('in')) {
        $timeout(() => {angular.element('#collapse-restriction').click();});
      }

      var ftiuids = $scope.selection.ftis.map(function(x) {
        return x.uid;
      });
      $scope.selection.selectedftis.map(function(fti, i) {
        if (ftiuids.indexOf(fti.uid) === -1) {
          checkMapSrid(fti);
          if (angular.isUndefined(fti.index)) fti.index = i;
          $scope.selection.ftis.push(fti);
          let l = gcWMS.getOlLayerFromFeaturetypeInfo(fti,undefined,$scope.map);
          if (angular.isUndefined(l.index)) l.index = i;
          l.setVisible(false);
          l.selectionable = false;
          $scope.Layers.insertAt(l.index, l);
          $scope.map.addLayer(l);
          if ($scope.Layers.getLength() === 1) {
            $scope.zoomLayer(l);
          }
        }
      });
    };


    $scope.removeFromGeocatalogue = function() {
      $scope.selection.selectedftis.map(function(x) {
        var ftiuids = $scope.selection.ftis.map(function(x) {
          return x.uid;
        });
        var ind = ftiuids.indexOf(x.uid);
        if (ind !== -1) $scope.selection.ftis.splice(ind, 1);

        ftiuids = $scope.Layers.getArray().map(function(x) {
          return x.fti.uid;
        });
        ind = ftiuids.indexOf(x.uid);
        if (ind !== -1) {
          $scope.map.removeLayer($scope.Layers.getArray()[ind]);
          $scope.Layers.removeAt(ind);
        }
      });
    };


    $scope.zoomLayer = (l) =>{
      FeatureTypeFactory.getExtent(
        l.fti.uid,$scope.map.getView().getProjection().getCode()).then(
        (res) => {
          $scope.map.getView().fit(res.data, $scope.map.getSize());
        },
        (data) => {
          require('toastr').info(data);
        }
      );
    };


    $scope.moveLayer = function(l, direction) {
      $scope.Layers.getArray().map(function(l) {
        $scope.map.removeLayer(l);
      });
      var delta = 1;
      var index = $scope.Layers.getArray().indexOf(l);
      $scope.Layers.removeAt(index);
      if (direction === 'up') {
        l.index = index - delta;
        $scope.Layers.insertAt(index - delta, l);
      } else {
        l.index = index + delta;
        $scope.Layers.insertAt(index + delta, l);
      }
      $scope.Layers.getArray().map(function(l) {
        $scope.map.addLayer(l);
      });
    };


    $scope.allLayersareVisible = false;
    $scope.allLayersareSelectable = false;

    $scope.allVisible = function() {
      $scope.allLayersareVisible = !$scope.allLayersareVisible;
      $scope.Layers.getArray().map(function(l) {
        l.setVisible($scope.allLayersareVisible);
        if (!$scope.allLayersareVisible)
          l.selectionable = $scope.allLayersareVisible;
      });
      $scope.allareSelectionable();
    };

    $scope.allSelectable = function() {
      $scope.allLayersareSelectable = !$scope.allLayersareSelectable;
      $scope.Layers.getArray().map(function(l) {
        l.selectionable = $scope.allLayersareSelectable;
        if ($scope.allLayersareSelectable && !l.getVisible())
          l.setVisible($scope.allLayersareSelectable);
      });
      $scope.allAreVisible();
    };

    $scope.allAreVisible = function() {
      var length = $scope.Layers.getLength();
      var intTrue = 0;
      var intFalse = 0;
      $scope.Layers.getArray().map(function(x) {
        x.getVisible() ? (intTrue += 1) : (intFalse += 1);
      });
      if (intTrue === length) $scope.allLayersareVisible = true;
      if (intFalse === length) $scope.allLayersareVisible = false;
    };

    $scope.allareSelectionable = function() {
      var length = $scope.Layers.getLength();
      var intTrue = 0;
      var intFalse = 0;
      $scope.Layers.getArray().map(function(x) {
        x.selectionable ? (intTrue += 1) : (intFalse += 1);
      });
      if (intTrue === length) $scope.allLayersareSelectable = true;
      if (intFalse === length) $scope.allLayersareSelectable = false;
    };

    $scope.checkUserModesDefault = function() {
      if (
        angular.isUndefined($scope.currentRestrictionRessource.modes.userchoice)
      ) {
        $scope.currentRestrictionRessource.modes.userchoice = true;
        $scope.changedForUser($scope.currentRestrictionRessource.modes);
      }
    };

    $scope.saveDatasource = function(datastore) {
      $scope.datastore = datastore;
      var data = {
        name: $scope.datastore,
      };
      RestrictionFactory.savedatastore(data).then(function(res) {
        if (res.data.etat === 'fini') {
          console.info('success save restriction globales');
          $scope.dialogdatastore.close();
          $scope.addRestriction();
        } else {
          console.info('no config');
          require('toastr').error(
            $filter('translate')('rights.restriction.erreurenregistrement')
          );
        }
      });
    };
  };

  RestrictionCtrl.$inject = [
    '$scope',
    'ngDialog',
    'RestrictionFactory',
    '$timeout',
    'FeatureTypeFactory',
    'gcWMS',
    '$filter',
    '$rootScope',
    'DataStoreFactory',
  ];
  return RestrictionCtrl;
});
