'use strict';

define(function() {
  var magicFactory = function($http, gaUrlUtils) {
    var magicFactory = {};

    /**
     * Function: getinfo
     * @param {String} id1 nom de la table
     * @param {String} id2 nom du champ de la table
     * @param {String} id3 chaine recherchée
     */
    function getinfo(id1, id2, id3) {
      return $http.get(
        '/services/{portalid}/majic/getInfo?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2 +
          '&id3=' +
          id3
      );
    }

    /**
     * Function: getparambyid (getParcelle)
     * @param {String} id1 valeur de 'idcommune'
     * @param {String} id2 valeur de 'idparcelle'
     */
    function getparambyid(id1, id2) {
      return $http.get(
        '/services/{portalid}/majic/getParcelle?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2
      );
    }
    /**
     * Function: getpropbyid
     * @param {String} id1 valeur de 'idcommune'
     * @param {String} id2 valeur de 'idcompte'
     * @param typeNom
     */
    function getpropbyid(id1, id2, typeNom) {
      id1 = gaUrlUtils.encodeUriQuery(id1 || '');
      id2 = gaUrlUtils.encodeUriQuery(id2 || '');
      return $http.get(
        '/services/{portalid}/majic/getProprietaire?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2 +
          '&typenom=' +
          typeNom
      );
    }
    /**
     * Function: getsubdibyid
     * @param {String} id1 valeur de 'idcommune'
     * @param {String} id2 valeur de 'idparcelle'
     */
    function getsubdibyid(id1, id2) {
      return $http.get(
        '/services/{portalid}/majic/getSubdivision?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2
      );
    }
    /**
     * Function: getexobyid
     * @param {String} id1 valeur de 'idcommune'
     * @param {String} id2 valeur de 'idparcelle'
     */
    function getexobyid(id1, id2) {
      return $http.get(
        '/services/{portalid}/majic/getExoneration?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2
      );
    }
    /**
     * Function: getbatibyid
     * @param {String} id1 valeur de 'idcommune'
     * @param {String} id2 valeur de 'idparcelle'
     * @param {String} typeLocal 'locauxPrincipaux' ou 'locauxDesLots'
     */
    function getbatibyid(id1, id2, typeLocal) {
      return $http.get(
        '/services/{portalid}/majic/getBatiment?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2 +
          '&typelocal=' +
          typeLocal
      );
    }
    /**
     * Function: getpevbyid
     * @param {String} id1 valeur de 'idcommune'
     * @param {String} id2 valeur de 'idparcelle'
     */
    function getpevbyid(id1, id2) {
      return $http.get(
        '/services/{portalid}/majic/getPEV?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2
      );
    }
    /**
     * Function: gethabbyid
     * @param {String} id1 valeur de 'idcommune'
     * @param {String} id2 valeur de 'idparcelle'
     */
    function gethabbyid(id1, id2) {
      return $http.get(
        '/services/{portalid}/majic/getHabitat?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2
      );
    }
    /**
     * Function: getdepbyid
     * @param {String} id1 valeur de 'idcommune'
     * @param {String} id2 valeur de 'idparcelle'
     */
    function getdepbyid(id1, id2) {
      return $http.get(
        '/services/{portalid}/majic/getDependance?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2
      );
    }
    /**
     * Function: getexolocbyid
     * @param {String} id1 valeur de 'idcommune'
     * @param {String} id2 valeur de 'idparcelle'
     */
    function getexolocbyid(id1, id2) {
      return $http.get(
        '/services/{portalid}/majic/getExoLoc?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2
      );
    }
    /**
     * Function: getparcellaire
     * @param {String} id1 nom du champ de la table nb_10.
     * @param {String} id2 une clause where
     */
    function getparcellaire(id1, id2) {
      return $http.get(
        '/services/{portalid}/majic/chargeCommune?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2
      );
    }
    /**
     * Function: getville
     * Liste des communes dans la base majic.
     */
    function getville() {
      return $http.get('/services/{portalid}/majic/chargeVille?f=json');
    }

    /**
     * Retrouve la liste des Communes (idcommune et libelle commune)
     */
    function getcommunes(condition) {
      return $http.get(
        '/services/{portalid}/majic/getCommunes?f=json' + '&id1=' + condition
      );
    }

    /**
     * Function: getlisteparcelle
     * @param {String} id1 une clause where
     */
    function getlisteparcelle(id1) {
      return $http.get(
        '/services/{portalid}/majic/chargeListeParcelle?f=json' + '&id1=' + id1
      );
    }
    /**
     * Function: getlisteproprio
     * @param {String} id1 une clause where sur la table 'prop'.
     * @param {String} id1 une clause where sur la table 'nb_10'
     * @param id2
     */
    function getlisteproprio(id1, id2) {
      const encodedId1 = gaUrlUtils.encodeUriQuery(id1);
      const encodedId2 = gaUrlUtils.encodeUriQuery(id2);
      return $http.get(
        '/services/{portalid}/majic/chargeListeProprio?f=json' +
          '&id1=' +
          encodedId1 +
          '&id2=' +
          encodedId2
      );
    }
    /**
     * Function: getlisteadresse
     * @param {String} id1 une clause where sur la table 'nb_10'.
     * @param {String} id2 une clause where sur la table 'f_commune'
     * @param {String} id3 une clause where sur la table 'f_voie'.
     */
    function getlisteadresse(id1, id2, id3) {
      const encodedId1 = gaUrlUtils.encodeUriQuery(id1);
      const encodedId2 = gaUrlUtils.encodeUriQuery(id2);
      const encodedId3 = gaUrlUtils.encodeUriQuery(id3);
      return $http.get(
        '/services/{portalid}/majic/chargeListeAdresse?f=json' +
          '&id1=' +
          encodedId1 +
          '&id2=' +
          encodedId2 +
          '&id3=' +
          encodedId3
      );
    }

    /**
     * Function: getlisteadresse
     * @param {String} idcommune code insee de la commune de la parcelle.
     * @param {String} idparcelle identifiant de la parcelle code insee
     *                  ancienne commune + section = no parcelles
     */
    function getcoproprietaires(idcommune, idparcelle) {
      return $http.get(
        '/services/{portalid}/majic/getPropietairesParLots?f=json' +
          '&id1=' +
          idcommune +
          '&id2=' +
          idparcelle
      );
    }
    /**
     * Function: getproprietairesCsv = get list proprietaires for import CSV
     *
     * @param {*} idcommune
     * @param {*} idparcelle
     * @param {*} idcompte
     * @param coprops
     */
    function getproprietairesCsv(idcommune, idparcelle, idcompte, coprops) {
      if (coprops !== undefined && coprops.length !== 0) {
        return getcoproprietaires(idcommune, idparcelle);
      } else {
        return getpropbyid(idcommune, idcompte, 'nom_d_usage');
      }
    }

    /**
     * Récupère les noms de rapports dans un objet config
     * Méthode partagée par MajicDockWidget et MajicConsult
     * @param config configuration du widget majic
     */
    function getReportNames(config){
      const reportsMap = new Map();
      // Nom des rapports Jasper
      let reportsConfig = config['reports'];
      if (reportsConfig &&
          reportsConfig.hasOwnProperty('MatCad') &&
          String(reportsConfig['MatCad']).length > 0
      ) {
        reportsMap.set('MatCadReportName', reportsConfig.MatCad);
      }
      if (reportsConfig &&
          reportsConfig.hasOwnProperty('RelProp') &&
          String(reportsConfig['RelProp']).length > 0
      ) {
        reportsMap.set('RelPropReportName', reportsConfig.RelProp);
      }
      return reportsMap;
    }

    /**
     * Récupère une map des communes MAJIC
     * @return {map} des communes MAJIC (code insee IDCOMMUNE => nom commune LIBCOM)
     */
    const getVilleInsee = () => {
      return $http.get(
          '/services/{portalid}/majic/getVilleInsee?f=json'
      );
    };

    let popupPanel;
    let popupCollapse;
    /**
     * Définie les dimensions de la popup à l'ouverture de celle-ci
     * @param viewMode string correspondant à l'onglet de la popup actuellement affiché ('consult' au départ)
     * @param fromTool est true si la popup est ouverte depuis le i rouge
     */
    const setInitPopupWidthAndMinWidth = (viewMode, fromTool=false) => {
      if (fromTool) {
        const majicConsult = document.getElementById('majicController');
        popupPanel = majicConsult.closest('.popupPanel');
      } else {
        if (!popupPanel) {
          const majicConsult = document.getElementById('majicController');
          if (majicConsult) {
            popupPanel = majicConsult.closest('.popup > .panel');
          }
        }
      }
      if (popupPanel && !popupCollapse){
        popupCollapse = popupPanel.getElementsByClassName('.panel-collapse')[0];
      }
      if (popupPanel) {
        if (viewMode && viewMode === 'search') {
          popupPanel.style.width = '990px';
          popupPanel.style.minWidth = '450px';
        } else{
          popupPanel.style.width = '820px';
          popupPanel.style.minWidth = '450px';
        }
      }
      if (popupCollapse) {
        popupCollapse.style.overflowY = 'auto';
      }
    };

    /**
     * A chaque mise à jour du dom,
     * renvoie true si la largeur de la popup est inférieure à 780px
     * ajoute des modifications de mise en page spécifique suivant l'onglet
     * et la largeur de la popup
     * @param viewMode search/consult...
     * @param fromTool est true si la popup est ouverte depuis le i rouge
     * @return {boolean} est true si la largeur de la popup est inférieure à 780px
     */
    const adaptPopupSizeByViewMode = (viewMode, fromTool=false) => {
      let isStretched = false;
      const majicConsult = document.getElementById('majicController');
      if (majicConsult) {
        // popupPanel est la div redimensionnable
        const popupPanel = fromTool ? majicConsult.closest('.popupPanel')
            : majicConsult.closest('.popup > .panel');
        if (popupPanel) {
          for (const child of popupPanel.children) {
            if (child.className === 'panel-collapse') {
              child.style.overflowY = 'auto';
            }
          }
          switch (viewMode) {
            case 'localconsult':
              break;
            case 'search':
              break;
            case 'baticonsult':
              break;
            case 'consult':
            default:
              const parcOnMapCbSpan = document.getElementById('parcOnMapCbSpan');
              if (popupPanel.offsetWidth < 780) {
                if (parcOnMapCbSpan){
                  parcOnMapCbSpan.textContent = 'Parcelle au plan';
                }
                isStretched = true
              } else if (parcOnMapCbSpan) {
                parcOnMapCbSpan.textContent = 'Parcelle figure au plan';
              }
              break;
          }
        }
      }
      return isStretched;
    };

    /**
     * Vérifie si le portail contient une source de données nommée "majic" uniquement (cf. KIS-2474)
     * @return {boolean} true si une source de données MAJIC existe
     */
    const hasMajicDataStore = () => {
      // Si un datastoreInfo nommé "majic" existe
      return $http.get(
          '/services/{portalid}/majic/hasMajicDataStore?f=json'
      );
    };
    /**
     * Vérifie si la source de données "majic" du portail contient la table f_commune (cf. KIS-2474)
     * @return {boolean} true si la table existe dans la source de données ainsi nommée.
     */
    const hasTableCommuneInMajicDataStore = () => {
      // Teste l'existence de la table f_commune dans la source de données nommée "majic"
      return $http.get(
          '/services/{portalid}/majic/hasTableCommuneInMajicDataStore?f=json'
      );
    };

    /**
     * Vérifie si le portail contient une source de données MAJIC.
     * Le test est fait sur l’existence de la table B_10
     * @return {boolean} true si un datastore existe contenant une table B_10
     */
    const hasTableB10InMajicDataStore = () => {
      return $http.get(
          '/services/{portalid}/majic/hasTableB10InMajicDataStore?f=json'
      );
    }

    return {
      magicFactory: magicFactory,
      getinfo: getinfo,
      getparambyid: getparambyid,
      getpropbyid: getpropbyid,
      getsubdibyid: getsubdibyid,
      getexobyid: getexobyid,
      getbatibyid: getbatibyid,
      getpevbyid: getpevbyid,
      gethabbyid: gethabbyid,
      getdepbyid: getdepbyid,
      getexolocbyid: getexolocbyid,
      getparcellaire: getparcellaire,
      getville: getville,
      getcommunes: getcommunes,
      getlisteparcelle: getlisteparcelle,
      getlisteproprio: getlisteproprio,
      getlisteadresse: getlisteadresse,
      getcoproprietaires: getcoproprietaires,
      getproprietairesCsv: getproprietairesCsv,
      getReportNames: getReportNames,
      setInitPopupWidthAndMinWidth: setInitPopupWidthAndMinWidth,
      adaptPopupSizeByViewMode: adaptPopupSizeByViewMode,
      getVilleInsee: getVilleInsee,
      hasMajicDataStore: hasMajicDataStore,
      hasTableCommuneInMajicDataStore: hasTableCommuneInMajicDataStore,
      hasTableB10InMajicDataStore: hasTableB10InMajicDataStore
    };
  };

  magicFactory.$inject = ['$http', 'gaUrlUtils'];

  return magicFactory;
});
