/**
 *
 */
'use strict';
if (
  !define(function() {
    /**
     * Builder Ctrl
     * @param $scope
     * @constructor
     * @param $rootScope
     * @param ngDialog
     * @param ApplicationFactory
     * @param ConfigFactory
     * @param $filter
     * @param FeatureTypeFactory
     */
    var LicenceCtrl = function(
      $scope,
      licenceFactory,
      $rootScope,
      ngDialog,
      $filter
    ) {
      licenceFactory.getAllLicences().then(function(res) {
        $scope.currentResources = [
          licenceFactory.getLicence($rootScope.xgos.portal.uid),
        ];
      });

      $scope.uploadLicence = function() {
        ngDialog.open({
          template: 'js/XG/modules/licence/views/add.licence.html',
          className: 'ngdialog-theme-plain  width350 height370 miniclose',
          closeByDocument: false,
          scope: $scope,
        });
      };
      $scope.checkLicenceCorrecte = function() {
        licenceFactory.CheckLicenceUploaded().then(
          function(res) {
            if (res.data === 'true') {
              licenceFactory.validerLicence().then(
                function(res) {
                  licenceFactory.reloadRepository().then(
                    function(res) {
                      licenceFactory.getAllLicences().then(function(res) {
                        $scope.currentResources = [
                          licenceFactory.getLicence($rootScope.xgos.portal.uid),
                        ];
                        if (
                          licenceFactory.getLicence(
                            $rootScope.xgos.portal.uid
                          ) &&
                          licenceFactory.getLicence($rootScope.xgos.portal.uid)
                            .type !== 'free'
                        )
                          licenceFactory.checkLicence(
                            licenceFactory.getLicence(
                              $rootScope.xgos.portal.uid
                            )
                          );
                        $scope.tableParams.reload();
                      });
                    },
                    function() {
                      console.error('erreur de reload');
                    }
                  );
                },
                function() {
                  console.error('erreur de copy');
                }
              );
            } else {
              require('toastr').error(
                $filter('translate')('licence.licence.licencenotavailabe')
              );
            }
          },
          function() {
            require('toastr').error(
              $filter('translate')('licence.licence.licencenotavailabe')
            );
          }
        );
      };

      $scope.showInfo = function() {
        ngDialog.open({
          template: 'js/XG/modules/licence/views/info.licence.html',
          className: 'ngdialog-theme-plain  width350 height50 miniclose',
          closeByDocument: false,
          scope: $scope,
        });
      };

      $scope.editListCfg = {
        dataModule: 'licence',
        resource_type: 'licence',
        cols: [
          'type',
          'start_date',
          'end_date',
          'referer',
          'applications',
          'nbapplications',
          'portal_connexion',
          'user_connexion',
        ],
        addFunction: $scope.uploadLicence,
        editFunction: $scope.showInfo,
        deleteResourceButton: false,
        dontShowLength: true,
        notAddMode: true,
        notPagination: true,
      };
    };

    LicenceCtrl.$inject = [
      '$scope',
      'licenceFactory',
      '$rootScope',
      'ngDialog',
      '$filter',
    ];
    return LicenceCtrl;
  })
) {
}
