'use strict';
define(function () {
  /**
   *
   * Class : extendedNgDialog
   * Extends the original ngdialog third party provider
   *
   * @param ngDialog
   * @param $rootScope
   * @param $document
   * @param $timeout
   * @param $filter
   * @param $http
   * @param dialogsCommon
   * @returns service functions (open, etc)
   */
  const extendedNgDialog = function (
    ngDialog,
    $rootScope,
    $document,
    $timeout,
    $filter,
    $http,
    dialogsCommon,
    $window,
    gaJsUtils
  ) {


    const popupHeight = (popupElement) => {
      return popupElement.height() - 44;
    };


    this.Popup = function(opts) {

      // -- Ticket pour le KIS-3606 ajout de l'option suivante:
      // -- option "broadcastHeightChanged" qui permet de signaler un changement de hauteur
      // -- aux enfants de la popup par envoi du message identifié par la valeur de cette option

      // create a new scope by extending the parent scope
      // add functions for popup features(drag drop, resize, minimize/maximize)
      opts.scope = opts.scope.$new();
      this.popup = $.extend({}, opts);
      this.popup.features = this.popup.scope;
      this.popup.features = $.extend(this.popup.features, opts);

      // booleans used to toggle different states(tab, normalized, maximized)
      this.popup.features.isMaximized = false;
      this.popup.features.isTab = false;
      this.popup.features.resizeEnabled = false;
      this.popup.features.dragActive = true;
      this.popup.features.popupStates = {};
      this.popup.features.boundings = {};
      this.popup.features.topOffset = null;

      // by default popups are draggable
      // by default close button is shown
      this.popup.features.draggable = opts.draggable !== false;
      this.popup.features.scrollable = opts.scrollable === true;
      this.popup.features.showClose = opts.showClose !== false;
      this.popup.features.makeTabAllOthers =
        this.popup.features.minimizeProperty === true;

      this.popup.features.className = opts.className || '';
      this.popup.features.formOptions = opts.formOptions ? opts.formOptions : {};
      if (!opts.title) {
        // if no title is provided -> take the title configured in the form itself
        this.popup.features.title = this.popup.features.formOptions.formTitle;
      }
      this.popup.features.position = opts.position || { top: 0, left: 0 };

      // utility functions
      // declared with null for hoisting purposes
      this.popup.features.closeDialog = null;
      this.popup.features.maximize = null;
      this.popup.features.normalize = null;
      this.popup.features.makeItTab = null;
      this.popup.features.updateProperties = null;
      this.popup.features.savePopupState = null;
      this.popup.features.toggleDraggable = null;
      this.popup.features.toggleResize = null;
      this.popup.features.activateDrag = null;
      this.popup.features.addEvents = null;
      this.popup.features.removeEvents = null;
      this.popup.features.resize = null;
      this.popup.features.startResize = null;
      this.popup.features.finishResize = null;
      this.popup.features.addCustomizations = null;
      this.popup.features.iddiv = generateUniqueId();

      $http
        .get('js/XG/modules/common/views/extendedNgDialogTemplate.html')
        .then(template => {
          const element = angular.element(template.data);
          this.popup.features.contentTemplate = this.popup.template;
          this.popup.template = element[0].outerHTML;
          this.popup.plain = true;
          this.popup.showClose = false;

          const dialogReturn = ngDialog.open(this.popup);
          this.popup = $.extend(this.popup, dialogReturn);
          if (opts.scope.closeCallback) {
            dialogReturn.closePromise.then(function(data) {
              opts.scope.closeCallback(data);
            });
          }
        });

      $('body').toggleClass('no_drop_modal');
      let deregNgDialog = $rootScope.$on('ngDialog.opened', (e, $dialog) => {
        this.popup.dialog = $dialog;
        // we need timeout because we need to wait for angular
        //to finish data model evaluation in the template
        $('.ngdialog').hide();
        $timeout(() => {
          let body = $('body');
          let popupElement = $(
            `div[ga-draggable-zone='#${this.popup.features.iddiv}zone']`
          );
          let popupContainer = popupElement.closest('.popupContainer');

          popupContainer
            .closest('.ngdialog')
            .attr('dialog-id', this.popup.features.iddiv);
          popupContainer.closest('.ngdialog').addClass('extendedNgDialog');

          body.append(popupContainer);
          $('.ngdialog').show();
          body.toggleClass('no_drop_modal');
          if(this.popup.features.addCustomizations){
            this.popup.features.addCustomizations();
          }
          this.popup.features.makeItFocused(popupElement, e);
        }, 0);
        deregNgDialog();
      });


      this.popup.features.minimize = () => {
        this.popup.features.makeItTab();
        let popupElement = $(
          `div[ga-draggable-zone='#${this.popup.features.iddiv}zone']`
        );
        popupElement.closest('.popupContainer').css('margin', 0);

        let nrOfPopups = $('.extendedNgDialog').length;

        popupElement.css({
          top: nrOfPopups * 50 - popupElement.height(),
          left: 20,
        });
      };


      $rootScope.$on('minimizePopup', (event, id) => {
        if (id === this.popup.features.iddiv && !this.popup.features.isTab) {
          this.popup.features.minimize();
        }
      });


      this.popup.features.onNgDialogClosed = (e, $dialog) => {
        let ngDialogId = $dialog.attr('id');

        if (ngDialogId === this.popup.id) {
          let dialogId = $dialog.attr('dialog-id');
          let dialogElement = $(`#${dialogId}`);
          dialogElement.remove();

          this.popup.features.removeEvents();
          this.popup.deregisterClosedEvent();
          $rootScope.$broadcast('onNgDialogClosed', ngDialogId);
        }
      };

      this.popup.deregisterClosedEvent = $rootScope.$on(
        'ngDialog.closed',
        this.popup.features.onNgDialogClosed
      );

      this.popup.features.closeDialog = () => {
        let dialog = $(`div[dialog-id='${this.popup.features.iddiv}']`);

        let dialogId = dialog.attr('id');
        ngDialog.close(dialogId);
      };

      this.popup.features.maximize = () => {
        this.popup.features.prevPopupHeight = this.popup.features.height;
        if (this.popup.features.isTab) {
          this.popup.features.savePopupState('minimized');
        }
        else {
          this.popup.features.savePopupState('normal');
        }

        const popupElement = $(
          `div[ga-draggable-zone='#${this.popup.features.iddiv}zone']`
        );
        popupElement.closest('.popupContainer').css('margin', 0);

        let leftMenu = $('.mapLeftMenu');
        let leftMenuCoordinates = {};

        const categoriesVerticalBar = $('.displayFirstLevel');
        let displayFirstLevelBoundings;
        if (categoriesVerticalBar && categoriesVerticalBar.length > 0) {
          displayFirstLevelBoundings = categoriesVerticalBar[0].getBoundingClientRect();
        }
        else {
          // la barre verticale des catégories n'est pas toujours présente (ex. page d'accueil)
          displayFirstLevelBoundings = {right:0,width:0};
        }

        const mapWidgetContainer = $('.mapMenuWrapper');
        let mapMenuWrapperBoundings;
        if (mapWidgetContainer && mapWidgetContainer.length > 0) {
          mapMenuWrapperBoundings = mapWidgetContainer[0].getBoundingClientRect();
        }
        else {
          // le conteneur d'un widget n'est pas toujours présent (ex. page d'accueil)
          mapMenuWrapperBoundings = {right:0,width:0};
        }

        if (leftMenu.find('.mapMenuWrapper').hasClass('active')) {
          leftMenuCoordinates.right = mapMenuWrapperBoundings.right;
          leftMenuCoordinates.width =
            displayFirstLevelBoundings.width + mapMenuWrapperBoundings.width;
        }
        else {
          leftMenuCoordinates.right = displayFirstLevelBoundings.right;
          leftMenuCoordinates.width = displayFirstLevelBoundings.width;
        }

        popupElement.find('.panel-collapse.extendedNgDialogContent').show();

        popupElement.css({
          width: `calc(100vw - ${leftMenuCoordinates.width}px`,
          height: 'calc(100vh)',
          position: 'absolute',
          left: leftMenuCoordinates.right,
          top: '0px',
        });

        this.popup.features.isTab = false;
        this.popup.features.isMaximized = true;
        this.popup.features.isMinimized = false;
        this.popup.features.resizeEnabled = false;

        // redimensionne la div contentTemplate
        setContentTemplateHeight(popupElement);
        this.popup.features.height = popupHeight(popupElement) + 'px';
        broadcastHeightChanged();
      };


      this.popup.features.normalize = () => {
        this.popup.features.prevPopupHeight = this.popup.features.height;
        let popupElement = $(
          `div[ga-draggable-zone='#${this.popup.features.iddiv}zone']`
        );
        popupElement.closest('.popupContainer').css('margin', 'auto');

        if (this.popup.features.isTab) {
          this.popup.features.savePopupState('minimized');
        }

        let popupProps = {
          top: this.popup.features.popupStates.normal.popupProperties.top,
          left: this.popup.features.popupStates.normal.popupProperties.left,
          width: this.popup.features.popupStates.normal.popupProperties.width,
          height: this.popup.features.popupStates.normal.popupProperties.height,
        };

        this.popup.features.updateProperties(popupProps);
        this.popup.features.isTab = false;
        this.popup.features.isMaximized = false;
        this.popup.features.isMinimized = false;
        this.popup.features.resizeEnabled = false;

        // redimensionne la div contentTemplate
        setContentTemplateHeight(popupElement);
        this.popup.features.height = popupHeight(popupElement) + 'px';
        broadcastHeightChanged();
      };

      this.popup.features.makeItTab = () => {
        if (!this.popup.features.isMaximized && !this.popup.features.isTab) {
          this.popup.features.savePopupState('normal');
          this.popup.features.savePopupState('minimized');
        }

        let popupElement = $(
          `div[ga-draggable-zone='#${this.popup.features.iddiv}zone']`
        );
        popupElement.closest('.popupContainer').css('margin', 'auto');

        if (this.popup.features.isTab) {
          // make it normal
          this.popup.features.isMinimized = false;
          popupElement.find('.panel-collapse.extendedNgDialogContent').show();
          this.popup.features.normalize();
          this.popup.features.isTab = false;
        }
        else {
          // make it tab
          this.popup.features.isMinimized = true;
          popupElement.find('.panel-collapse.extendedNgDialogContent').hide();
          let tittleWidth = popupElement.find('.popupName').outerWidth() + 118;

          // KIS-3082: en voulant minimiser la fenêtre, celle-ci prend toute la hauteur de la page
          let titleHeight = popupElement.find('.headerpopup').outerHeight();

          let minimizedOffsets;
          if (this.popup.features.popupStates.minimized) {
            minimizedOffsets = {
              top: this.popup.features.popupStates.minimized.popupProperties
                .top,
              left: this.popup.features.popupStates.minimized.popupProperties
                .left,
            };
          }
          else {
            minimizedOffsets = {
              top: this.popup.features.position.top,
              left: this.popup.features.position.left,
            };
          }

          popupElement.css({
            top: minimizedOffsets.top,
            left: minimizedOffsets.left,
            height: titleHeight,
            width: tittleWidth,
          });

          this.popup.features.isTab = true;
        }

        this.popup.features.isMaximized = false;
        this.popup.features.resizeEnabled = false;
      };

      this.popup.features.updateProperties = popupProps => {
        let popupElement = $(
          `div[ga-draggable-zone='#${this.popup.features.iddiv}zone']`
        );

        popupElement.css({
          top: popupProps.top,
          left: popupProps.left,
          width: popupProps.width,
          height: popupProps.height,
        });
      };

      /**
       * Le cas échéant envoyer un message aux enfants de la poup
       * afin qu'ils puissent mettre à jour leurs dimensions
       */
      const broadcastHeightChanged = () => {

        let newPopupHeight = this.popup.features.height;
        if (opts.broadcastHeightChanged && this.popup.features.prevPopupHeight !== newPopupHeight) {
          opts.scope.$broadcast(opts.broadcastHeightChanged,
            {
              heightDelta: parseInt(newPopupHeight) - parseInt(this.popup.features.prevPopupHeight),
              containerHeight: newPopupHeight
            });
        }
      };


      this.popup.features.savePopupState = state => {
        let popupElement = $(
          `div[ga-draggable-zone='#${this.popup.features.iddiv}zone']`
        );
        let popupBoundings = popupElement[0].getBoundingClientRect();
        let popupPosition = popupElement.position();

        this.popup.features.popupStates[state] = {
          popupProperties: {
            top: popupPosition.top,
            left: popupPosition.left,
            width: popupBoundings.width,
            height: popupBoundings.height,
          },
        };
      };

      this.popup.features.toggleDraggable = event => {
        let targetParent = $(event.target).closest('.headerpopup');

        this.popup.features.dragActive = targetParent.hasClass('headerpopup');
      };

      this.popup.features.toggleResize = (event, state) => {
        this.popup.resizeEnabled = state;
      };

      this.popup.features.activateDrag = event => {
        let eventTarget = $(event.target).hasClass('resizeSide');
        if (!eventTarget) {
          this.popup.resizeEnabled = false;
        }
      };

      this.popup.features.dragPopup = (popupElement, left, top) => {

        const popupWidth = parseInt(popupElement.css('width'));
        const halfScreenWidth = window.innerWidth / 2;
        const halfScreenHeight = window.innerHeight / 2;
        let newLeft = left;
        let newTop = top;

        //left
        if (left < -halfScreenWidth) {
          newLeft = -halfScreenWidth;
        }
        //right
        if (left + popupWidth > halfScreenWidth) {
          newLeft = halfScreenWidth - popupWidth;
        }
        //top
        if (top < -halfScreenHeight) {
          newTop = -halfScreenHeight;
        }
        //bottom
        if (top + 44 > halfScreenHeight) {
          newTop = halfScreenHeight-44; // 44 is the popup label's height
        }

        popupElement.css({
          left: newLeft,
          top: newTop
        });
      };

      this.popup.features.addEvents = () => {
        // only add events if dialog is resizable
        if (this.popup.features.resizable) {
          $(document).on('mousemove', this.popup.features.resize);
          $(document).on('mousedown', this.popup.features.startResize);
          $(document).on('mouseup', this.popup.features.finishResize);
        }
      };

      this.popup.features.removeEvents = () => {
        // after dialog is closed, remove the events associated with it
        if (this.popup.features.resizable) {
          $(document).off('mousemove', this.popup.features.resize);
          $(document).off('mousedown', this.popup.features.startResize);
          $(document).off('mouseup', this.popup.features.finishResize);
        }
      };


      this.popup.features.resize = event => {
        const popupElement = $(
          `div[ga-draggable-zone='#${this.popup.features.iddiv}zone']`
        );
        if (!popupElement.data('focusedPopup')) {
          return;
        }

        let popupBoundings = popupElement[0].getBoundingClientRect();
        let mousePosition = { left: event.clientX, top: event.clientY };
        let body = $('body');
        body.css({ 'user-select': 'none' });

        switch (this.popup.features.resizeSide) {
          case 'topResize': {
            let popupIncrement = popupBoundings.top - mousePosition.top;
            let newPopupHeight =
              popupElement.height() + (popupBoundings.top - mousePosition.top);

            popupElement.height(newPopupHeight);
            popupElement.css({
              top: popupElement.position().top - popupIncrement,
            });
            body.css({ cursor: 'n-resize' });
            this.popup.features.height
              = isPopupDimValid(popupHeight(popupElement),this.popup.features.minHeight) ?
                popupHeight(popupElement) + 'px'
                : (gaJsUtils.isolateCssSizeNumericValue(this.popup.features.minHeight) -44) + 'px' ;

            // KIS-3082: mauvais dimensionnement de la fenêtre et/ou agencement
            // des éléments contenus dans la fenêtre
            removeFixedHeightOnVerticalResize(popupElement);

            break;
          }
          case 'rightResize': {
            let newPopupWidth =
              popupElement.width() + mousePosition.left - popupBoundings.right;
            let popupLeftPosition = popupElement.position().left;

            popupElement.width(newPopupWidth);
            popupElement.css({
              left: popupLeftPosition,
            });

            body.css({ cursor: 'e-resize' });
            this.popup.features.width
              = isPopupDimValid(popupElement.width(),this.popup.features.minWidth) ?
                popupElement.width() + 'px' : this.popup.features.minWidth;
            break;
          }
          case 'bottomResize': {
            let newPopupHeight =
              popupElement.height() + mousePosition.top - popupBoundings.bottom;
            let popupTopPosition = popupElement.position().top;

            popupElement.height(newPopupHeight);
            popupElement.css({
              top: popupTopPosition,
            });
            body.css({ cursor: 'n-resize' });

            // KIS-3082: mauvais dimensionnement de la fenêtre et/ou agencement
            //des éléments contenus dans la fenêtre
            removeFixedHeightOnVerticalResize(popupElement);

            this.popup.features.height = setRezizedContentTemplateHeight(popupElement);
            break;
          }
          case 'leftResize': {
            let popupIncrement = popupBoundings.left - mousePosition.left;
            let newPopupWidth =
              popupElement.width() + (popupBoundings.left - mousePosition.left);

            popupElement.width(newPopupWidth);
            popupElement.css({
              left: popupElement.position().left - popupIncrement,
            });
            body.css({ cursor: 'e-resize' });
            this.popup.features.width
              = isPopupDimValid(popupElement.width(),this.popup.features.minWidth) ?
                popupElement.width() + 'px' : this.popup.features.minWidth;
            break;
          }
        }
      };

      this.popup.features.startResize = event => {
        this.popup.features.prevPopupHeight = this.popup.features.height;
        if (!this.popup.features.isMaximized &&
          !this.popup.features.isTab &&
          $(event.target).hasClass('resizeSide')
        ) {
          this.popup.features.resizeSide = $(event.target)
            .attr('class')
            .split(' ')[1];
        }
      };

      this.popup.features.hide = () => {
        document.getElementById(this.popup.features.iddiv).style.display = 'none';
      };

      this.popup.features.show = () => {
        document.getElementById(this.popup.features.iddiv).style.display = 'block';
      };


      this.popup.features.finishResize = () => {
        $('body').css({ cursor: 'auto' });
        this.popup.features.resizeSide = null;

        // -- Le cas échéant envoyer un message aux enfants de la poup
        // -- afin qu'ils puissent mettre à jour leurs dimensions
        broadcastHeightChanged();
      };

      /**
       * Place la popup au 1er plan
       * @param iddiv attribut html 'id' de la div enfant
       * @see this.popup.features.iddiv
       */
      this.popup.features.onForeground = (iddiv) =>{
        if ($('.popupContainer').length>1){
          $('.popupContainer').css('zIndex', 2100);
          $('#'+iddiv).css( 'zIndex', 2101);
        }
      };

      this.popup.features.makeItFocused = function(htmlElem,event0) {
        $timeout(function(event) {
          if(event || event0) {
            $(htmlElem).closest('.popupContainer').css('z-index', dialogsCommon.getMaxIndex());
          }
        });

        $('.popupPanel').data('focusedPopup', false);
        $(htmlElem).closest('.popupPanel')
          .data('focusedPopup', true);
      };

      this.popup.features.addEvents();

      this.popup.features.addCustomizations = () => {
        let popupElement = $(
          `div[ga-draggable-zone='#${this.popup.features.iddiv}zone']`
        );
        let popupContainer = popupElement.closest('.popupContainer');

        popupContainer.addClass(this.popup.features.className);

        if (this.popup.features.formOptions.formHeight) {
          popupElement.css('height',
            this.popup.features.formOptions.formHeight + 'vh');
        }
        if (this.popup.features.formOptions.formWidth) {
          popupElement.css('width',
            'calc(' + this.popup.features.formOptions.formWidth + 'vw - 60px)');
        }

        if (this.popup.features.formOptions.formPosition) {
          // this config is stored in the form itself
          // AND it has priority over the other position config
          placeFormAt(popupElement, this.popup.features.formOptions.formPosition);
        }
        else if (
          this.popup.features.position.top !== 0 ||
          this.popup.features.position.left !== 0
        ) {
          // this config is in the intervflow widget
          popupContainer.removeClass('centered');

          popupElement.css({
            left: this.popup.features.position.left,
            top: this.popup.features.position.top,
          });
        }

        if (this.popup.features.makeTabAllOthers) {
          let allPopups = $('.popupContainer');

          for (let index = 0; index < allPopups.length; index++) {
            let popupId = $(allPopups[index]).attr('id');

            if (popupId !== this.popup.features.iddiv) {
              // minimize all other popups
              $rootScope.$broadcast('minimizePopup', popupId);
            }
          }
        }
      };

      function placeFormAt(popupElement, position) {
        let cssConfig;
        switch(position) {
          case 'top_left':
            cssConfig = {
              top: 'calc(-50vh)',
              left: 'calc(-50vw + 50px)'
            };
            break;
          case 'top_right':
            cssConfig = {
              top: 'calc(-50vh)',
              right: 'calc(-50vw + 50px)'
            };
            break;
          case 'center':
            cssConfig = {
              margin: 'auto',
              top: 'auto',
              bottom: 'auto',
              left: 'auto',
              right: 'auto'
            };
            break;
          case 'bottom_left':
            cssConfig = {
              bottom: 'calc(-50vh - 20px)',
              left: 'calc(-50vw + 50px)'
            };
            break;
          case 'bottom_right':
            cssConfig = {
              bottom: 'calc(-50vh - 20px)',
              right: 'calc(-50vw + 50px)'
            };
            break;
          default:
            console.error('unknown position setting: ' + position);
            break;
        }
        if (popupElement && cssConfig) {
          popupElement.css(cssConfig);
        }
      }

      function generateUniqueId() {
        const uniqueID = new Date();
        const myRandom = Math.floor(Math.random() * 1000);
        return uniqueID.getTime() + '' + myRandom;
      }

      /**
       * Définition des dimensions et de la position que la popup doit prendre
       * quand celle-ci passe d'un état réduit à normal
       * @param {object} popupPropsToSet position top/left et dimensions width/height
       */
      this.popup.features.setNormalSize = (popupPropsToSet) => {
        if (popupPropsToSet) {
          if (!this.popup.features.popupStates.normal
              || !this.popup.features.popupStates.normal.popupProperties) {
            this.popup.features.popupStates.normal = {
              popupProperties: {}
            };
          }
          this.popup.features.popupStates.normal.popupProperties.top = popupPropsToSet.top;
          this.popup.features.popupStates.normal.popupProperties.left = popupPropsToSet.left;
          this.popup.features.popupStates.normal.popupProperties.width = popupPropsToSet.width;
          this.popup.features.popupStates.normal.popupProperties.height = popupPropsToSet.height;
        }
      };

      return this.popup;
    };

    /**
     * Allow the dialog to be dragged while holding mousedown on the handler
     * @param element
     * @param opts
     */
    let makeDraggable = function(element, opts) {
      const paramx = 320;

      const paramy = 300;

      let $dialog = element.find('.ngdialog-content'),
        borderSpacing = 10,
        $dialogWidth = $dialog.outerWidth(),
        $dialogHeight = $dialog.outerHeight(),
        startX = 0,
        startY = 0,
        x = paramx,
        y = paramy,
        handler = angular.element(
          '<h3 class="modalTitle ngdialog_handler">' +
            $filter('translate')(opts.title) +
            '</h3>'
        );

      console.log($dialogHeight);
      console.log('er');

      // reset dialog position
      $dialog.css({
        position: 'absolute',
        left: x,
        top: y,
      });

      $dialog.prepend(handler);

      handler.on('mousedown', function(event) {
        // Prevent default dragging of selected content
        event.preventDefault();
        startX = event.screenX - x;
        startY = event.screenY - y;

        $document.on('mousemove', mousemove);
        $document.on('mouseup', mouseup);
      });

      function mousemove(event) {
        y = event.screenY - startY;
        x = event.screenX - startX;

        // Make it impossible to push the dialog out of the client window
        let borders = {
          right: window.screen.availWidth - $dialogWidth - borderSpacing,
          left: borderSpacing,
          top: borderSpacing + 94,
          bottom: window.screen.availHeight - borderSpacing - 47,
        };

        if (x > borders.right) {
          x = borders.right;
        }
        if (x < borders.left) {
          x = borders.left;
        }
        if (y < borders.top) {
          y = borders.top;
        }
        // useless ?
        if (x < borders.left) {
          y = borders.left;
        }

        // it should be possible to go under the maxheight as long as the
        // draggable part is still visible
        if (y > borders.bottom) y = borders.bottom;

        $dialog.css({
          top: y + 'px',
          left: x + 'px',
        });
      }

      function mouseup() {
        $document.off('mousemove', mousemove);
        $document.off('mouseup', mouseup);
      }
    };

    /**
     * Vérifie si la hauteur/largeur de la popup est supérieure à la hauteur/largeur mini
     * @param currentDim valeur courante de la hauteur ou de la largeur de la popup
     * @param dimValueLimit valeur la plus basse admise pour la hauteur/largeur
     * @return {boolean} true si la hauteur/largeur courante est supérieure
     *     à la hauteur-min/largeur-min
     */
    const isPopupDimValid = (currentDim, dimValueLimit) => {
      if (dimValueLimit) {
        if (Number.isInteger(dimValueLimit)) {
          return currentDim > Number.parseInt(dimValueLimit);
        } else {
          const dimLimitAsNum = Number.parseFloat(dimValueLimit);
          if (dimValueLimit.endsWith('px')) {
            return currentDim > dimLimitAsNum;
          }
          else if (dimValueLimit.endsWith('vh')) {
            return currentDim > ($window.innerHeight * dimLimitAsNum / 100);
          }
          else if (dimValueLimit.endsWith('vw')) {
            return currentDim > ($window.innerWidth * dimLimitAsNum / 100);
          }
        }
      }
      return true;
    };

    /**
     * Dimensionnement du contentTemplate à l'initialisation
     * @param popup
     */
    const initContentTemplateSize = (popup) => {
      $timeout(() => {
        // définit la hauteur et la largeur
        if (popup.formOptions && Number.isFinite(popup.formOptions.formHeight)
          && Number.isFinite(popup.formOptions.formWidth)) {
          popup.features.height = ((popup.formOptions.formHeight * $window.innerHeight / 100)
            - 44) + 'px';
          popup.features.width = '100%';
        }
        else {
          const popupDiv = document.getElementById(popup.features.iddiv);
          if (popupDiv && popupDiv.children.length > 0
              && popupDiv.children[0].clientHeight > 0 && popupDiv.children[0].clientWidth > 0) {
            popup.features.height =  (popupDiv.children[0].clientHeight - 44) + 'px';
            popup.features.width = popupDiv.children[0].clientWidth + 'px';
          }
        }
        // ajoute la hauteur de la barre de titre à la valeur minHeight
        if (popup.features.minHeight) {
          const heightAsNum = Number.parseInt(popup.features.minHeight);
          if (heightAsNum > 0) {
            if (popup.features.minHeight.endsWith('px')) {
              popup.features.minHeight = (heightAsNum + 44) + 'px';
            }
            else if (popup.features.minHeight.endsWith('vh')) {
              const pxWithTitleBar = (($window.innerHeight * heightAsNum / 100) + 44);
              const vhWithTitleBar = (pxWithTitleBar * 100) / $window.innerHeight;
              popup.features.minHeight = vhWithTitleBar + 'vh';
            }
            // KIS-3079: mauvais dimensionnement de la popup.
            // Les boutons Fermer/Enregistrer n'étaient pas positionnés
            // au bas de la popup.
            // La popup prend la hauteur du contenu (minHeight+44 par défaut)
            if (!popup.features.height
              && !popup.features.doNotForcePopupHeightToMinHeight) {
              popup.features.height = popup.features.minHeight;
            }
          }
        }
      });
    };

    /**
     * A chaque redimensionnement vertical de la popup,
     * calcule la valeur de la hauteur du contentTemplate.<br>
     * Assure que la hauteur du contentTemplate ne soit pas inférieure
     * à la hauteur minimale si celle-ci existe.<br>
     * Prend en compte les hauteurs minimales notées en px ou en vh
     * @param popupElement élement HTML de la popup (titre compris)
     * @return {string} hauteur du contentTemplate de la popup
     */
    const setRezizedContentTemplateHeight = (popupElement) => {
      if (this.popup && this.popup.features && typeof this.popup.features.minHeight === 'string'
          && this.popup.features.minHeight.length > 0) {
        const minHeightAsNum = Number.parseInt(this.popup.features.minHeight);
        if (!isPopupDimValid((popupHeight(popupElement)), this.popup.features.minHeight)
          && minHeightAsNum > 0) {
          if (this.popup.features.minHeight.endsWith('px')) {
            return (minHeightAsNum - 44) + 'px';
          }
          else if (this.popup.features.minHeight.endsWith('vh')) {
            const pxValue = ($window.innerHeight * minHeightAsNum / 100) - 44;
            return (pxValue * 100 / $window.innerHeight) + 'vh';
          }
        }
      }
      return popupHeight(popupElement) + 'px';
    };

    /**
     * Définit la hauteur du conteneur du corps de la popup
     * en fonction de la hauteur de la popup entière.
     * Il s'agit de la hauteur de la popup à laquelle on soustrait la hauteur de la barre
     * de titre fixe à 44px
     * @param popupElement élement HTML de la popup
     */
    const setContentTemplateHeight = (popupElement) => {
      if (Object.prototype.hasOwnProperty.call(popupElement, 0)) {
        const popupDiv = popupElement[0];
        const popupContent = popupDiv.querySelector('.contentTemplate');
        if (popupContent) {
          popupContent.style.height = popupHeight(popupElement) + 'px';
        }
      }
    };

    /**
     * Lors d'un redimensionnement de popup, dans le cas d'un formulaire (IS et autres),
     * cette méthode permet de contourner le paramètre "Hauteur" de la configuration du formulaire.
     * En effet, pour redimensionner une popup, le corps de la popup ne peut pas avoir
     * une hauteur fixe.
     * @param popupElement element JQuery contenant le corps de la popup
     */
    const removeFixedHeightOnVerticalResize = (popupElement) => {
      if (popupElement) {
        const jQueryRenderedForm = popupElement.find('.renderedForm');
        const bypassFormFixedHeight = 'height:100% !important;';
        if (jQueryRenderedForm) {
          const renderedForm = jQueryRenderedForm[0];

          if (renderedForm) {
            if (!renderedForm.hasAttribute('style')) {

              // créé un attribut de style inline
              renderedForm.setAttribute('style', bypassFormFixedHeight);

            } else {

              // ajoute la propriété à l'attribut de style inline existant
              let elementStyle = renderedForm.getAttribute('style');
              if (typeof elementStyle === 'string' && elementStyle.length > 0
                && !elementStyle.includes(bypassFormFixedHeight)) {
                if (!elementStyle.endsWith(';')) {
                  elementStyle += ';';
                }
                elementStyle += bypassFormFixedHeight;
                renderedForm.setAttribute('style', elementStyle);
              }
            }
          }
        }
      }
    };

    /**
     * Extends the ngDialog open method
     * @param opts paramétrage de la popup fourni par la directive exécutant la méthode .open()
     */
    this.open = function(opts) {
      const popup = new this.Popup(opts);

      // Dimensionnement du contentTemplate à l'initialisation
      initContentTemplateSize(popup);

      return popup;
    };

    /**
     * the old ngDialog open method
     * @param opts
     */
    this.openOld = function(opts) {
      let bodyClasses = document.getElementsByTagName('body')[0].className;
      if (bodyClasses.indexOf('no_drop_modal') === -1) {
        document.getElementsByTagName('body')[0].className += ' no_drop_modal';
      }

      // Open the dialog
      let dialogInfos = ngDialog.open(opts);

      // when the dialog is opened, makeitDraggable
      let deregNgDialog = $rootScope.$on('ngDialog.opened', function(
        e,
        $dialog
      ) {
        // if it is the targeted dialog
        if (dialogInfos.id === $dialog.attr('id')) {
          $dialog
            .removeClass('ngdialog-overlay')
            .addClass('ngdialog-no-overlay ngdialog-draggable');
          document.getElementsByTagName(
            'body'
          )[0].className = document
            .getElementsByTagName('body')[0]
            .className.replace('no_drop_modal', '');
          // timeout to be sure the dom is rendered
          $timeout(function() {
            // hacky // todo : make it better @rb
            let dialogContent = $dialog.find('.ngdialog-content');
            let decalageTop = window.screen.availHeight;
            dialogContent[0].style.marginTop = '-' + decalageTop + 'px';
            if (opts.draggable) {
              makeDraggable($dialog, opts);
            }
          },0);
        }
        deregNgDialog();
      });
      return dialogInfos;
    };
    return this;
  };

  extendedNgDialog.$inject = [
    'ngDialog',
    '$rootScope',
    '$document',
    '$timeout',
    '$filter',
    '$http',
    'dialogsCommon',
    '$window',
    'gaJsUtils'
  ];
  return extendedNgDialog;
});
