'use strict';
define(function() {
  /**
   * formatDateToLocale
   * @returns {Function}
   */
  var formatDateToLocale = function() {
    return function(d) {
      if (d) {
        if (moment(d).isValid()) {
          return moment(d)
            .toDate()
            .toLocaleString(navigator.language, {
              day: '2-digit',
              month: '2-digit',
              year: '2-digit',
              hour: '2-digit',
              minute: '2-digit',
            });
        } else {
          return d;
        }
      }
    };
  };

  formatDateToLocale.$inject = [];
  return formatDateToLocale;
});
