'use strict';
define(function() {
  /**
   * Display (indent + newlines) an xml string
   * @returns {Function}
   */
  var displayXML = function() {
    return function(xml) {
      if (xml !== void 0) {
        var formatted = '';
        var reg = /(>)(<)(\/*)/g;
        xml = xml.replace(reg, '$1\r\n$2$3');
        var pad = 0;
        jQuery.each(xml.split('\r\n'), function(index, node) {
          var indent = 0;
          if (node.match(/.+<\/\w[^>]*>$/)) {
            indent = 0;
          } else if (node.match(/^<\/\w/)) {
            if (pad != 0) {
              pad -= 1;
            }
          } else if (node.match(/^<\w[^>]*[^\/]>.*$/)) {
            indent = 1;
          } else {
            indent = 0;
          }

          var padding = '';
          for (var i = 0; i < pad; i++) {
            padding += '  ';
          }

          formatted += padding + node + '\r\n';
          pad += indent;
        });

        return formatted
          .replace(/&#x2F;/g, '/')
          .replace(/</g, '&lt;')
          .replace(/>/g, '&gt;')
          .replace(/ /g, '&nbsp;')
          .replace(/\n/g, '<br />');
      }
    };
  };

  displayXML.$inject = [];
  return displayXML;
});
