'use strict';
define(function() {
  var parameterSaveLoad = function(
    ParametersFactory,
    $translate,
    $rootScope,
    $filter
  ) {
    return {
      templateUrl:
        'js/XG/modules/common/views/directives/parameter_save_load.html',
      scope: {
        type: '@',
        loadMapping: '&',
        saveMapping: '&',
      },
      restrict: 'EA',
      link: function(scope, element, attr) {
        scope.mappingToLoad = {};
        scope.currentMapping = {};

        /**
         * refresh mapping list
         */
        var refreshMappingList = function() {
          ParametersFactory.getbytype(scope.type).then(function(res) {
            scope.mappingList = res.data;
          });
        };

        refreshMappingList();
        $rootScope.$on('refreshParameterMappingList', function(event, data) {
          if (data.type == scope.type) {
            refreshMappingList();
          }
        });

        /**
         *  load parameter mapping
         */
        scope.innerLoad = function() {
          scope.loadMapping({ data: scope.mappingToLoad.value });
        };
        /**
         *  save parameter mapping
         */
        scope.innerSave = function() {
          var nameExist = scope.mappingList
            .map(function(x) {
              return x.name;
            })
            .indexOf(scope.currentMapping.name);

          var ans = 1;
          if (nameExist != -1)
            ans = confirm(
              $filter('translate')(
                'common.directives.parameter_save_load.name_exist'
              )
            );
          if (ans) {
            scope.saveMapping({ data: scope.currentMapping.name });
          }
        };
      },
    };
  };

  parameterSaveLoad.$inject = [
    'ParametersFactory',
    '$translate',
    '$rootScope',
    '$filter',
  ];
  return parameterSaveLoad;
});
