'use strict';
define(function() {
  var navGroup = function($location) {
    return {
      restrict: 'EA',
      scope: {
        checkpath: '=',
        infos: '=groupinfos',
      },
      link: function($scope, element, attrs) {
        $scope.isCollapsed = true;

        var groupLi = angular.element(element[0].querySelector('.group'));

        groupLi.on('click', function() {
          groupLi.removeClass('active');
          if (!$scope.isCollapsed) {
            groupLi.addClass('active');
          }
        });

        var search = $location.url().split('?');
        $scope.urlParameters = '';
        if (search.length > 1) {
          $scope.urlParameters = '?' + search[1];
        }

        $scope.main_title = $scope.infos.main_title;
        $scope.icon = $scope.infos.icon;
        $scope.subs = $scope.infos.subs;

        // checks if the group needs to be opened
        $scope.activeSub = false;
        $scope.subs.forEach(function(sub) {
          if ($scope.checkpath('/' + sub.target + '/')) {
            $scope.activeSub = true;
            //$scope.isCollapsed = false;
          }
          $scope.isCollapsed = false;
        });

        /**
         * get sub link, nothing if disabled
         * @param sub
         * @returns {string}
         */
        $scope.getSubLink = function(sub) {
          return sub.disabled
            ? ''
            : '#' + sub.target + '' + $scope.urlParameters;
        };
        $scope.showGroup = function(subs) {
          return subs.findIndex(item => item.visible == true)!=-1;
        };
      },
      templateUrl: 'js/XG/modules/common/views/navGroup.html',
    };
  };

  navGroup.$inject = ['$location'];
  return navGroup;
});
