'use strict';
define(function() {
  var kisCalendarFactory = function(
    ConfigFactory,
    AncAppFactory,
    $rootScope,
    $filter,
    CalendarFactory,
    FeatureTypeFactory,
    $q
  ) {
    var resources = {
      config: {
        eventTypes: []
      },
    };
    var dossierFTI;

    var mapTypeControle = {
      FO0: 'kis_anc_standard_fo0_reception',
      FO1: 'kis_anc_standard_fo1_conception',
      FO2: 'kis_anc_standard_fo2_realisation',
      FO3_mutation: 'kis_anc_standard_fo3_existant',
      FO3: 'kis_anc_standard_fo3_existant',
      FO4_mutation: 'kis_anc_standard_fo4_bon_fonctionnement',
      FO4: 'kis_anc_standard_fo4_bon_fonctionnement',
      Vidange: 'kis_anc_standard_controle_vidange',
      Ponctuel: 'kis_anc_standard_controle_ponctuel',
    };

    ConfigFactory.get('ANC', 'calendar').then(function(res) {
      if (res.data != '') resources.config = res.data;
    });

    function getColorFromConfig(eventTypeProps) {
      var iEt, ets, color;
      if (resources.config != undefined) {
        ets = resources.config.eventTypes;
        if (ets){
          for (iEt = 0; iEt < ets.length; iEt++) {
            if (ets[iEt].type_id == eventTypeProps.type_id) {
              color = ets[iEt].color;
            }
          }
        }
         
      }
      if (color == undefined) color = eventTypeProps.default_color;
      return color;
    }

    function getEventFromTypeDeControle(controle, eventTypes, pTypeControle) {
      var color, type_evenement, found, typeControle;
      if (pTypeControle != undefined) typeControle = pTypeControle;
      else typeControle = mapTypeControle[controle.properties.type];
      found = eventTypes.some(function(eventType) {
        if (typeControle == eventType.properties.type) {
          color = getColorFromConfig(eventType.properties);
          type_evenement = eventType.properties.type_id;
          return true;
        }
      });
      return { found: found, color: color, typeEvent: type_evenement };
    }

    function getDossierFti() {
      if (
        AncAppFactory.appCfg &&
        AncAppFactory.appCfg.main &&
        AncAppFactory.appCfg.main.datastore
      ) {
        var dossierFTI = FeatureTypeFactory.getFeatureByNameAndDatastore(
          AncAppFactory.appCfg.main.datastore,
          'kis_anc_dossier'
        );
      }
      return dossierFTI
    }

    function refreshListeDossier() {
      if (dossierFTI == undefined) dossierFTI = getDossierFti();
      if (dossierFTI) {
        $rootScope.$broadcast('refreshDatatable', { uid: dossierFTI.uid });
      }
    }

    /**
     *    Suppression d'un événement du calendrier.
     */
    function annulerEvent(idOfEventToDelete, closeEvent, idDossier) {
      var ans = confirm($filter('translate')('calendar.event.cancel_event'));
      if (ans) {
        var id = idOfEventToDelete.split('.');
        return CalendarFactory.cancelevent(id[1],idDossier).then(function(res) {
          refreshListeDossier();
          if (closeEvent != undefined) closeEvent();
        });
      }
      return $q.reject();
    }

    return {
      getEventFromTypeDeControle: getEventFromTypeDeControle,
      annulerEvent: annulerEvent,
      refreshListeDossier: refreshListeDossier,
      resources: resources,
    };
  };
  kisCalendarFactory.$inject = [
    'ConfigFactory',
    'AncAppFactory',
    '$rootScope',
    '$filter',
    'CalendarFactory',
    'FeatureTypeFactory',
    '$q',
  ];
  return kisCalendarFactory;
});
