/**
 *
 */
'use strict';
define(function() {
  var ChercherModSupCtrl = function(
    $scope,
    ChercherModSupFactory,
    QueryFactory,
    ConfigFactory,
    FeatureTypeFactory,
    GlobalServices,
    SelectManager,
    $q,
    $timeout,
    gaJsUtils
  ) {
    $scope.selectedMapFeatures = [];

    $scope.buildFieldDescription = function() {
      if ($scope.fieldDesc.relations == null) $scope.fieldDesc.relations = [];

      //-- Store related tables description.
      $scope.componentEndDescField = [];
      for (var ind2 = 0; ind2 < $scope.fieldDesc.relations.length; ind2++)
        $scope.componentEndDescField.push(
          FeatureTypeFactory.getFeatureTypeDesc(
            $scope.config.datastoreName,
            $scope.fieldDesc.relations[ind2].componentEnd
          )
        );

      //-- Store related tables description on each concerned relation.
      var ind3, ind4;
      for (ind3 = 0; ind3 < $scope.fieldDesc.relations.length; ind3++)
        for (ind4 = 0; ind4 < $scope.componentEndDescField.length; ind4++)
          if (
            $scope.componentEndDescField[ind4] != null &&
            $scope.fieldDesc.relations[ind3].componentEnd ==
              $scope.componentEndDescField[ind4].name
          )
            $scope.fieldDesc.relations[ind3].componentEndDescField =
              $scope.componentEndDescField[ind4];
      $scope.relationsLoaded =
        $scope.componentEndDescField.length ==
        $scope.fieldDesc.relations.length;
      $scope.ready = $scope.objectToUpdateLoaded && $scope.relationsLoaded;

      //-- Set information telling the job is done.
      if ($scope.fieldDesc.relations.length == 0) $scope.relationsLoaded = true;
      $scope.ready = $scope.relationsLoaded;
    };

    $scope.defineDefaultConfig = function(featureName) {
      /*
             * Example of simple configuration
             *
             *
            {
              "datastoreName": "yamoussoukro",
              "featureName": "day_installation_sportive",
              "searchResultModifyConfig": {
                                            "config": {
                                               {
                                                  "state": "update",
                                                  "updateMode": "inline",
                                                  "contentType": "panelContainer",
                                                  "datastoreName": "yamoussoukro",
                                                  "featureName": "day_installation_sportive"
                                               }
                                            }
                                          }
            }
            */
      if (featureName.indexOf('.') == -1) return;
      var cfg = ($scope.config = {});
      var tfn = featureName.split('.');
      cfg.datastoreName = tfn[0];
      cfg.featureName = tfn[1];
      cfg.searchResultModifyConfig = {};
      var tableDesc = FeatureTypeFactory.getFeatureTypeDesc(tfn[0], tfn[1]);
      if (tableDesc == undefined)
        gaJsUtils.errorMessage(
          'Composant non trouvé: [' + featureName + ']',
          ''
        );
      else {
        GlobalServices.defineDefaultConfigManageRelations(
          cfg,
          tfn[0],
          tfn[1],
          tableDesc
        );
        var cfg2 = (cfg.searchResultModifyConfig.config = {});
        if ($scope.stateFromParent == 'view') cfg2.state = 'view';
        else cfg2.state = 'update';
        cfg2.updateMode = 'inline';
        cfg2.contentType = 'panelContainer';
        cfg2.datastoreName = tfn[0];
        cfg2.featureName = tfn[1];
        GlobalServices.defineDefaultConfigManageRelations(
          cfg2,
          tfn[0],
          tfn[1],
          tableDesc
        );
      }
    };

    /**
     *        Get configuration, description of tables/layers
     *    and eventually database object from server
     *    while this is not done the widget construction is waiting.
     *    When it is done  << $scope.ready >> is set to true
     *    and the compilation starts.
     */
    $scope.loadWidgetStep1 = function() {
      var ind2, ind3;
      $scope.panelUse = 'search';
      $scope.found = false;

      if (ChercherModSupFactory.resources.config == null) {
        //-- Ask for configuration.
        ConfigFactory.get('chercher_modifier', $scope.ConfigName).then(function(
          res
        ) {
          //            	ChercherModSupFactory.getConfig($scope.myConfig,"").then(function () {
          //-- <<<< Configuration has been gotten. >>>>
          $scope.config = res.data;
          $scope.panelFields = $scope.config.panelFields;
          $scope.specialFields = $scope.config.specialFields;
          $scope.fieldOrder = $scope.config.fieldOrder;
          $scope.tableMainFields = $scope.config.tableMainFields;
          $scope.excludedFields = $scope.config.excludedFields;
          $scope.tableMainFields = $scope.config.tableMainFields;

          if ($scope.config == null || $scope.config == '')
            $scope.defineDefaultConfig($scope.ConfigName);

          if (
            $scope.config == null ||
            $scope.config == '' ||
            $scope.config.datastoreName == null
          )
            alert('Configuration du widget incorrecte !');
          else {
            $scope.objectToUpdateLoaded = $scope.config.state != 'update';

            //-- Get feature type description of the "table" containing the object to manage.
            $scope.fieldDesc = FeatureTypeFactory.getFeatureTypeDesc(
              $scope.config.datastoreName,
              $scope.config.featureName
            );

            if (res.fieldDesc !== undefined) $scope.buildFieldDescription();
            else
              FeatureTypeFactory.get().then(function() {
                $scope.fieldDesc = FeatureTypeFactory.getFeatureTypeDesc(
                  $scope.config.datastoreName,
                  $scope.config.featureName
                );
                if ($scope.fieldDesc != null) $scope.buildFieldDescription();
                $scope.widgetIsLoaded = true;
              });
          }
        });
      }
    };

    $scope.update = function() {
      setTimeout(function() {
        if (!$scope.ready) $scope.update();
        else {
          var elt = document.getElementById(
            'cherchermodsupdirective_' + $scope.$id
          );
          var str = '';
          str +=
            "<b ng-if='config.title!=undefined' ng-show='!found' >{{config.title}}</b>";
          str +=
            '<div FormFieldPanelDirective ng-show="!found" ng-keypress="keyPressed($event)">';
          str += '</div>';
          str +=
            '<button ng-click="search()"  ng-show="!found">Chercher</button>';
          str +=
            '<button ng-click="getSelectedObjectsFromMap()"  ng-show="!found && fieldDesc.geographic" >Sélection carte</button>';
          var cmp = $scope.compile(str)($scope);
          angular.element(elt).append(cmp);
        }
      }, 250);
    };

    /*
        $scope.loadWidget = function ()
        {
            if ($scope.loadWidgetWaitCount==undefined)
                $scope.loadWidgetWaitCount = 0;
            $scope.eltChercher = document.getElementById("cherchermodsupdirective_"+$scope.$id);
            if ($scope.eltChercher==undefined)
               {
                if ($scope.loadWidgetWaitCount<240)
                   {
                    $timeout($scope.loadWidget,500);
                    $scope.loadWidgetWaitCount++;
                   }
                else
                    $timeout($scope.loadWidget,1750);
               }
            else if ($scope.eltChercher.getBoundingClientRect().width!=0)
                GlobalServices.initialize().then(
                    function (res)
                    {
                        $scope.loadWidgetStep1();
                        $scope.update();
                    }
                );
            else
                $timeout($scope.loadWidget,500);
        };
        $scope.loadWidget();
*/

    $scope.$on('openTools_cherchermodsupdirective', function(event, data) {
      var cfgName = data.config;
      if (cfgName == undefined) cfgName = data.configName;
      if ($scope.ConfigName == cfgName && $scope.widgetIsLoaded == undefined)
        GlobalServices.initialize().then(function(res) {
          $scope.loadWidgetStep1();
          $scope.update();
        });
    });

    /**
     *
     */
    $scope.getValueFor = function(desc, fieldName, value) {
      for (var ind1 = 0; ind1 < desc.attributes.length; ind1++)
        if (desc.attributes[ind1].name == fieldName) {
          if (!desc.attributes[ind1].fieldTypeIsString && value == '')
            return null;
          if (desc.attributes[ind1].fieldTypeIsDate) {
            if (value == undefined) return '';
            if (value.trim != undefined)
              //-- Date value as STRING object
              return value + 'T12:00:00.000';
            //-- Date value as DATE object
            //2006-11-30T01:30:00+03:00
            else
              return (
                '' +
                value.getFullYear() +
                '-' +
                (1 + value.getMonth()) +
                '-' +
                value.getDate() +
                'T12:00:00+00:00'
              );
            //                             return ""+value.getFullYear()+"-"+(1+value.getMonth())+"-"+value.getDate()+"T12:00:00.000+0000";
            //return "2016-01-02T12:00:00.000+0000";
          }
        }

      return value;
    };

    $scope.storeQueryResults = function(features, query) {
      var iFeat, values;
      if (query.storeResults != undefined) {
        values = $scope.queryStoredValues[query.storeResults.variable] = [];
        for (iFeat = 0; iFeat < features.length; iFeat++) {
          values.push(features[iFeat].properties[query.storeResults.field]);
        }
      }
    };

    /**
     *     Filtre forcément construit avec l'opérateur IN.
     *  On construit la clause where du styel id_operation IN (1,2,3).
     */
    $scope.getFilterObjBuildWhere = function(queryObj) {
      var fn,
        part,
        newQuery = '',
        query = queryObj.where,
        valueList = [],
        val;

      //-- Y a-t-il un mot clef "lastResult" à gérer
      var indStr1 = query.indexOf('!lastResult!'),
        indStrFieldEnd;
      if (indStr1 == -1) newQuery = query;
      else {
        if ($scope.gfowcObj.previousRes.length == 0) return null;
        indStrFieldEnd = query.indexOf('!', indStr1 + 14);
        fn = query.substr(indStr1 + 14, indStrFieldEnd - indStr1 - 14);
        for (
          var indObj = 0;
          indObj < $scope.gfowcObj.previousRes.length;
          indObj++
        ) {
          if (fn == 'id')
            val = QueryFactory.getFeatureId(
              $scope.gfowcObj.previousRes[indObj]
            );
          else val = $scope.gfowcObj.previousRes[indObj].properties[fn];
          if (val != null && valueList.indexOf(val) == -1) valueList.push(val);
        }
        newQuery =
          query.substr(0, indStr1) +
          valueList.valueOf() +
          query.substr(indStrFieldEnd + 1);
      }
      newQuery = GlobalServices.getObjUsingQueriesBuildWhere(newQuery);

      //-- Y a-t-il un mot clef "storedVariable" à gérer
      var indStr1 = newQuery.indexOf('!storedVariable!'),
        indStrFieldEnd;
      if (indStr1 != -1) {
        indStrFieldEnd = newQuery.indexOf('!', indStr1 + 18);
        var varName = newQuery.substr(
          indStr1 + 18,
          indStrFieldEnd - indStr1 - 18
        );
        var varValues = $scope.queryStoredValues[varName].join();
        newQuery =
          newQuery.substr(0, indStr1) +
          varValues +
          newQuery.substr(indStrFieldEnd + 1);
      }

      return newQuery;
    };

    $scope.getFilterObjWhereClause = function(deferred) {
      //-- Récupére le query de l'index courant
      var query =
        $scope.config.searchFilterObj[$scope.gfowcObj.indexOfSearchFilter];
      //-- Positionne l'index sur le query suivant pour la prochaine "boucle"
      $scope.gfowcObj.indexOfSearchFilter++;
      //-- Récupére la description de la table à interroger
      var fti = FeatureTypeFactory.getFeatureTypeDesc(
        query.datastoreName,
        query.featureType
      );
      //- Construire la clause where de la requête
      var where = $scope.getFilterObjBuildWhere(query);

      //-- Si l'objet de gestion de réponse asynchrone n'est pas instancié, on l'instancie
      if ($scope.gfowcObj.deferred == undefined)
        $scope.gfowcObj.deferred = $q.defer();

      if (
        $scope.gfowcObj.indexOfSearchFilter ==
          $scope.config.searchFilterObj.length ||
        where == null
      ) {
        //-- La dernière requête de la liste a été exécutée
        $scope.gfowcObj.deferred.resolve(where);
        $scope.gfowcObj = undefined;
      } else {
        //-- Exécution de la requête
        QueryFactory.data(fti.uid, where).then(function(res) {
          //-- Récupération du résultat de la requête
          $scope.gfowcObj.previousRes = res.data.features;
          //-- Eventuel stockage de résultata de la requête
          $scope.storeQueryResults(res.data.features, query);
          //-- On passe à la requête suivante par appel récursif
          $scope.getFilterObjWhereClause();
        });
      }
      if ($scope.gfowcObj != undefined) return $scope.gfowcObj.deferred.promise;
    };

    /**
     *      Build where clause using values input in the panel
     *  and eventually concatenating the filter set in the configuration.
     */
    $scope.buildWhere = function() {
      var ind, ind2, value, value2, fn, rel, ope;
      var deferred = $q.defer();

      //--  Look for input values.
      $scope.where = '';
      for (ind = 0; ind < $scope.fieldDesc.attributes.length; ind++) {
        fn = $scope.fieldDesc.attributes[ind].name;
        value = null;
        if ($scope.panelFields == undefined)
          $scope.panelFields = $scope.fieldList;
        for (ind2 = 0; ind2 < $scope.panelFields.length; ind2++) {
          if ($scope.panelFields[ind2].objectField.name == fn) {
            value = $scope.getValueFor(
              $scope.fieldDesc,
              fn,
              $scope.panelFields[ind2].objectField.value
            );
            value2 = $scope.getValueFor(
              $scope.fieldDesc,
              fn,
              $scope.panelFields[ind2].objectField.value2
            );
            ope = $scope.panelFields[ind2].objectField.operator;
            break;
          }
          rel = $scope.panelFields[ind2].relation;
          if (rel != undefined) {
            //-- Identifier field name is part of the relation
            if (fn == rel.fieldEnd || fn == rel.fieldStart) {
              //-- So get the identifier value for it
              value = $scope.panelFields[ind2].objectField.value;
              break;
            }
          }
        }
        if (value != null && value != '') {
          //-- Cas où 2 fois date de mande dont un sans fieldTypeIsDate qu il ne faut pas traiter ...
          if (
            $scope.fieldDesc.attributes[ind].type
              .toLowerCase()
              .indexOf('.date') != -1 &&
            !$scope.fieldDesc.attributes[ind].fieldTypeIsDate
          )
            continue;

          if ($scope.where != '') $scope.where += ' AND ';

          //-- Case of where clause on a string value.
          if (!$scope.fieldDesc.attributes[ind].fieldTypeIsString)
            $scope.where += fn + ' ';

          if ($scope.fieldDesc.attributes[ind].fieldTypeIsString) {
            var reg = new RegExp("'", 'g');
            value = value.toLowerCase().replace(reg, "''");
            $scope.where += '(strToLowerCase(' + fn + ') ';
            $scope.where += "like '%" + value + "%' or ";
            $scope.where += 'strToLowerCase(' + fn + ') ';
            $scope.where += "like '" + value + "%' or ";
            $scope.where += 'strToLowerCase(' + fn + ') ';
            $scope.where += "like '%" + value + "')";
          }

          //-- Case of where clause on date.
          else if ($scope.fieldDesc.attributes[ind].fieldTypeIsDate) {
            //-- Possible operators are TEQUALS,AFTER,BEFORE or BETWEEN
            //-- the latter is coded as AFTER first date and BEFORE last date.
            if (ope == 'BETWEEN')
              $scope.where +=
                "> '" + value + "' AND " + fn + " < '" + value2 + "'";
            else $scope.where += ope + " '" + value + "'";
          }

          //-- Case of where clause on boolean.
          else if ($scope.fieldDesc.attributes[ind].fieldTypeIsBoolean) {
            if (value == 1) $scope.where += '= TRUE';
            else $scope.where += '= FALSE';
          } else {
            $scope.where += '=' + value;
          }
        }
      }

      if (
        $scope.config.searchFilter != undefined &&
        $scope.config.searchFilter != ''
      ) {
        if ($scope.where != '') $scope.where += ' AND ';
        $scope.where += GlobalServices.getObjUsingQueriesBuildWhere(
          $scope.config.searchFilter
        );
      }
      if ($scope.config.searchFilterObj == undefined) deferred.resolve('ok');
      else {
        if ($scope.gfowcObj != undefined) {
          gaJsUtils.errorMessage("requête déjà en cours d'exécution !'", '');
          deferred.resolve('error');
        } else {
          $scope.gfowcObj = {};
          $scope.gfowcObj.indexOfSearchFilter = 0;
          $scope.queryStoredValues = {};
          $scope.getFilterObjWhereClause().then(function(res) {
            if (res == null)
              gaJsUtils.errorMessage(
                "Aucun objet satisfaisant les critéres n'a été trouvé",
                ''
              );
            else {
              if ($scope.where != '') $scope.where += ' AND ';
              $scope.where += res;
              $scope.gfowcObj = undefined;
              deferred.resolve('ok');
            }
            $scope.gfowcObj = undefined;
          });
        }
      }
      return deferred.promise;
    };

    $scope.backToSearch = function() {
      $scope.found = false;
      $scope.displayResult = false;
      $scope.childScope.$destroy();
      var elt = document.getElementById('searchresultdiv_' + $scope.$id);
      var eltParent = document.getElementById(
        'cherchermodsupdirective_' + $scope.$id
      );
      eltParent.removeChild(elt);

      elt = document.getElementById('backtosearchbtn_' + $scope.$id);
      eltParent.removeChild(elt);
    };

    /************************************************************************************
     *      PREPARE DATA FOR SEARCHRESULT COMPONENT
     */

    /**
     *       Extract id value from id string which looks like
     *    "featuretypename.X" where X is the identifier value.
     */
    $scope.getFeatureId = function(feature) {
      var indPt;

      indPt = feature.id.indexOf('.');
      if (indPt == -1) return feature.id;
      else return feature.id.substr(indPt + 1);
    };

    $scope.gotValForComputeRelValueOfFeatures = function(res, layerUid) {
      var fn;

      if (res.data.features.length == 0)
        $scope.childScope.features[$scope.indFeatureToGetRelval].properties[
          fn
        ] = '';
      else {
        if (
          $scope.relationFieldsToCompute[$scope.indRelationToCompute] ==
          undefined
        )
          var ab = 'rr';
        else {
          fn =
            $scope.relationFieldsToCompute[$scope.indRelationToCompute].relation
              .name;
          if ($scope.currentMainFieldName != undefined)
            $scope.childScope.features[$scope.indFeatureToGetRelval].properties[
              fn
            ] = res.data.features[0].properties[$scope.currentMainFieldName];
          else
            $scope.childScope.features[$scope.indFeatureToGetRelval].properties[
              fn
            ] = $scope.getFeatureId(
              $scope.childScope.features[$scope.indFeatureToGetRelval]
            );
        }
      }
      $scope.indFeatureToGetRelval++;
      $scope.computeRelValueOfFeatures(layerUid);
    };

    $scope.computeRelValueOfFeatures = function(layerUid) {
      var where, val, fn;

      if ($scope.childScope.features == undefined) return;
      if ($scope.indFeatureToGetRelval == $scope.childScope.features.length) {
        $scope.indRelationToCompute++;
        $scope.computeRelationFields();
        return;
      }

      if ($scope.featureField == 'id')
        val = $scope.getFeatureId(
          $scope.childScope.features[$scope.indFeatureToGetRelval]
        );
      else
        val =
          $scope.childScope.features[$scope.indFeatureToGetRelval].properties[
            $scope.featureField
          ];
      if (val == null) {
        fn =
          $scope.relationFieldsToCompute[$scope.indRelationToCompute].relation
            .name;
        $scope.childScope.features[$scope.indFeatureToGetRelval].properties[
          fn
        ] = '';
        $scope.indFeatureToGetRelval++;
        $scope.computeRelValueOfFeatures(layerUid);
      } else {
        if ($scope.fieldForWhere == 'id')
          QueryFactory.get(layerUid, val).then(function(res) {
            $scope.gotValForComputeRelValueOfFeatures(res, layerUid);
          });
        else {
          where = $scope.fieldForWhere + '=' + val;
          var crs = $scope.map
            .getView()
            .getProjection()
            .getCode();
          QueryFactory.data(layerUid, where, crs).then(function() {
            $scope.gotValForComputeRelValueOfFeatures(res, layerUid);
          });
        }
      }
    };

    $scope.getRelationMainField = function(tableName) {
      var ind01;

      for (ind01 = 0; ind01 < $scope.config.tableMainFields.length; ind01++) {
        if ($scope.config.tableMainFields[ind01].table == tableName) {
          $scope.currentMainFieldName =
            $scope.config.tableMainFields[ind01].fields[0].field;
          break;
        }
      }
    };

    $scope.computeRelationFields = function() {
      var ind01, component, relation, res;

      if (
        $scope.indRelationToCompute == $scope.relationFieldsToCompute.length
      ) {
        $scope.prepareSearchResultDataReady = true;
        return;
      }
      relation =
        $scope.relationFieldsToCompute[$scope.indRelationToCompute].relation;
      if (relation.componentStart == $scope.config.featureName) {
        component = relation.componentEnd;
        $scope.fieldForWhere = relation.fieldEnd;
        $scope.featureField = relation.fieldStart;
      } else {
        component = relation.componentStart;
        $scope.fieldForWhere = relation.fieldStart;
        $scope.featureField = relation.fieldEnd;
      }
      $scope.getRelationMainField(component);
      $scope.indFeatureToGetRelval = 0;
      res = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.config.datastoreName,
        component
      );
      $scope.computeRelValueOfFeatures(res.uid);
    };

    $scope.getFieldAsRelation = function(fieldName) {
      var ind01, relations;

      relations = $scope.fieldDesc.relations;
      for (ind01 = 0; ind01 < relations.length; ind01++) {
        if (relations[ind01].name == fieldName) return relations[ind01];
      }
      return null;
    };

    $scope.getAttributeFromDescription = function(fieldName) {
      var ind01, attributes;

      attributes = $scope.fieldDesc.attributes;
      for (ind01 = 0; ind01 < attributes.length; ind01++) {
        if (attributes[ind01].name == fieldName) return attributes[ind01];
      }
      return null;
    };

    $scope.isARelationField = function(fieldName) {
      var relations;

      relations = $scope.fieldDesc.relations;
      for (var ind2 = 0; ind2 < relations.length; ind2++) {
        if (
          (relations[ind2].fieldEnd == fieldName &&
            relations[ind2].componentEnd == $scope.fieldDesc.name) ||
          (relations[ind2].fieldStart == fieldName &&
            relations[ind2].componentStart == $scope.fieldDesc.name)
        )
          return true;
      }
      return false;
    };

    /**
     *       If search result configuration does not exist
     *    the result table will contain the values for each standard field
     *    (ie no related object value, relation are omitted).
     *       If search result configuration exists
     *    only the listed fields will be displayed in the table.
     *    In case one of the field is a relation, then the main field
     *    of the related object will be displayed.
     */
    $scope.prepareSearchResultData = function() {
      var ind01, fn, fieldAsRelation;

      $scope.attributes = [];
      $scope.prepareSearchResultDataReady = false;
      if (
        $scope.config.searchResultFields == null ||
        $scope.config.searchResultFields.length == 0
      ) {
        //-- No configuration, so display every field value except relation fields
        for (ind01 = 0; ind01 < $scope.fieldDesc.attributes.length; ind01++) {
          fn = $scope.fieldDesc.attributes[ind01];
          if (!$scope.isARelationField(fn.name)) $scope.attributes[ind01] = fn;
        }
        $scope.prepareSearchResultDataReady = true;
      } else {
        //-- Field list is defined so take it into account
        $scope.relationFieldsToCompute = [];
        for (
          ind01 = 0;
          ind01 < $scope.config.searchResultFields.length;
          ind01++
        ) {
          fn = $scope.config.searchResultFields[ind01].name;
          fieldAsRelation = $scope.getFieldAsRelation(fn);
          if (fieldAsRelation != null) {
            $scope.relationFieldsToCompute.push({
              fn: fn,
              relation: fieldAsRelation,
            });
            $scope.attributes[ind01] = {};
            $scope.attributes[ind01].name = fn;
            $scope.attributes[ind01].alias = fn;
            $scope.attributes[ind01].type = 'java.lang.String';
          } else {
            $scope.attributes[ind01] = $scope.getAttributeFromDescription(fn);
          }
          //-- If an alias is defined for this display then take it into account
          if ($scope.config.searchResultFields[ind01].alias != undefined) {
            $scope.attributes[ind01].alias =
              $scope.config.searchResultFields[ind01].alias;
          }
        }
        $scope.indRelationToCompute = 0;
        $scope.computeRelationFields();
      }
    };

    /*************************************************************************************
     ************************************************************************************/

    $scope.loadSearchResultWhenReady = function() {
      if (!$scope.prepareSearchResultDataReady) {
        if ($scope.loadCallCount++ > 50)
          alert("Temps d'attente trop long: Opération abandonnée");
        else setTimeout($scope.loadSearchResultWhenReady, 250);
      } else {
        var elt = document.getElementById(
          'cherchermodsupdirective_' + $scope.$id
        );
        //      	  	var str = '<div TypeProjetDirective my-config="'+$scope.config.updateConfigName+'" >';
        var str =
          '<div SearchResultDirective ng-show="displayResult" id="searchresultdiv_' +
          $scope.$id +
          '" style="max-width:700px;overflow-x:scroll;">';
        str += '</div>';
        str +=
          '<button ng-click="backToSearch()"  ng-show="displayResult" id="backtosearchbtn_' +
          $scope.$id +
          '"><img src="img/common/24px-Go-previous.png" ></img></button>';
        $scope.childScope.attributes = $scope.attributes;
        var cmp = $scope.compile(str)($scope.childScope);
        angular.element(elt).append(cmp);
      }
    };

    $scope.gereCaractereSpeciauxDeWherePourUrl = function() {
      //-- Replace + character by %2b code
      var len = $scope.where.length;
      for (var ind = 0; ind < len; ind++)
        if ($scope.where.substr(ind, 1) == '+')
          $scope.where =
            $scope.where.substr(0, ind) + '%2b' + $scope.where.substr(ind + 1);
      /*    bonne chance pour utiliser cette méthode
            var reg = new RegExp("\x2B", "g");
            $scope.where = $scope.where.replace(reg,"%2b");
            */
    };

    /**
     *     Put map selected features into $scope.selectedMapFeatures array.
     */
    $scope.getFeatureFromSelectManager = function(fromSelectChangeEvent) {
      $scope.selectedMapFeatures.splice(0, $scope.selectedMapFeatures.length);
      //-- Get selected objects which belong to the related feature
      var selectedFeatures = SelectManager.getfeatures();
      if (selectedFeatures.features !== undefined)
        for (var ind = 0; ind < selectedFeatures.features.length; ind++)
          if (
            $scope.fieldDesc != null &&
            QueryFactory.getFeatureName(selectedFeatures.features[ind]) ==
              $scope.fieldDesc.name
          ) {
            //-- Build the relation between the main object and the selected one.
            $scope.selectedMapFeatures.push(selectedFeatures.features[ind]);
          }
      if (
        fromSelectChangeEvent &&
        $scope.config != undefined &&
        $scope.config.searchFilter != undefined &&
        ($scope.selectedMapFeatures.length != 0 || fromSelectChangeEvent)
      )
        $scope.search(true);
    };

    /**
     *    Being informed the map selection changed, allows to get newly selected features
     * and make the list of selected objects updated automatically.
     */
    $scope.$on('gcSelectChange', function(event, data) {
      //-- If the result widget has been opened from the command getting map selection
      //-- and not from the command executing the query.
      //-- On accepte de passer dans getFeatureFromSelectManager quand data n'est pas défini
      //-- car cela signifie que la liste d'objets est vide et donc il faut vide la liste des résultats.
      if (
        ($scope.displayResult && $scope.shownResultsCommeFromMap) ||
        data == undefined
      ) {
        $scope.getFeatureFromSelectManager(true);
      }
    });

    $scope.getSelectedObjectsFromMap = function() {
      $scope.shownResultsCommeFromMap = true;
      $scope.getFeatureFromSelectManager(false);
      if (
        $scope.config.searchFilter == undefined ||
        $scope.selectedMapFeatures.length == 0
      )
        $scope.searchDisplayResult($scope.selectedMapFeatures);
      else $scope.search(true);
    };

    /**
     *    When the map selection is used and a filter is set in the configuration
     *  the method "searchDisplayResult" is called and we add the list
     *  of the map selected objects identifiers to the query.
     */
    $scope.addMapResultToWhere = function(where) {
      var first = true;
      if ($scope.selectedMapFeatures.length == 0)
        //-- Quand la liste sélectionné sur la carte est vide, on met dans la requête
        //-- une condition qui ne retourne rien : "id in(0)".
        where = '(' + where + ') and id in (0)';
      else {
        where = '(' + where + ') and id in (';
        for (var ind = 0; ind < $scope.selectedMapFeatures.length; ind++) {
          if (!first) where += ',';
          where += QueryFactory.getFeatureId($scope.selectedMapFeatures[ind]);
          first = false;
        }
        where += ')';
      }
      return where;
    };

    /*
		$scope.setChildScopeFeaturesWhenReady= function()
		{
		 if ($scope.prepareSearchResultDataReady)
		 	 $scope.childScope.features = features;
		 else
		 	 setTimeout($scope.setChildScopeFeaturesWhenReady,500);
		};
*/
    $scope.refreshQueryResult = function() {
      $scope.prepareSearchResultDataReady = false;
      $scope.search($scope.lastUseMapresultParamValue);
      //setTimeout($scope.setChildScopeFeaturesWhenReady,500);
    };

    $scope.searchDisplayResult = function(features) {
      $scope.found = true;
      $scope.displayResult = true;
      if (
        $scope.childScope != undefined &&
        !$scope.childScope.$$destroyed &&
        $scope.$id != $scope.childScope.$id
      ) {
        $scope.childScope.features = features;
        $scope.prepareSearchResultData();
        return;
      }
      var childScope = $scope.$new();
      childScope.features = features;
      childScope.fieldDesc = $scope.fieldDesc;
      childScope.searchResultFields = $scope.config.searchResultFields;
      childScope.searchResultCascadeDeleteRelations =
        $scope.config.searchResultCascadeDeleteRelations;
      childScope.searchResultModifyConfig =
        $scope.config.searchResultModifyConfig;
      childScope.searchResultConfig = $scope.config.searchResultConfig;
      if ($scope.config.searchResultProgList != undefined)
        childScope.searchResultProgList = $scope.config.searchResultProgList;
      childScope.refreshQueryResult = $scope.refreshQueryResult;
      $scope.childScope = childScope;
      $scope.loadCallCount = 0;
      $scope.prepareSearchResultData();
      $scope.loadSearchResultWhenReady();
    };

    /**
     *    Query for objects using input field values of the panel.
     *  When result received, display the list of data.
     */
    $scope.search = function(useMapResult) {
      var where;
      var crs = $scope.map
        .getView()
        .getProjection()
        .getCode();
      $scope.lastUseMapresultParamValue = useMapResult;
      $scope.buildWhere().then(function(res) {
        if (res == 'error') return;
        where = $scope.where;
        if (useMapResult === true) where = $scope.addMapResultToWhere(where);
        $scope.gereCaractereSpeciauxDeWherePourUrl();
        QueryFactory.data($scope.fieldDesc.uid, where, crs).then(function(res) {
          if (useMapResult === true) {
            //-- Empty list of map selected features (used by search result widget).
            $scope.selectedMapFeatures.splice(
              0,
              $scope.selectedMapFeatures.length
            );
            for (var ind = 0; ind < res.data.features.length; ind++) {
              //-- Update list of selected features used by the searchresult widget.
              $scope.selectedMapFeatures.push(res.data.features[ind]);
            }
          } else {
            $scope.shownResultsCommeFromMap = false;
          }
          $scope.searchDisplayResult(res.data.features);
        });
      });
    };

    $scope.keyPressed = function($event) {
      if ($event.charCode == 13) $scope.search();
    };
  };
  ChercherModSupCtrl.$inject = [
    '$scope',
    'ChercherModSupFactory',
    'QueryFactory',
    'ConfigFactory',
    'FeatureTypeFactory',
    'GlobalServices',
    'SelectManager',
    '$q',
    '$timeout',
    'gaJsUtils',
  ];
  return ChercherModSupCtrl;
});
