'use strict';
define(function() {
  var FormFieldDirective = function() {
    return {
      templateUrl:
        'js/XG/biz/yamoussoukro/modules/form/formfield/view/FormField.html',
      restrict: 'A',
      controller: 'FormFieldCtrl',
      scope: false,
      link: function(scope, elm, attrs) {
        //-- Get informed that the input value has changed
        //-- to enforce input control when a number value
        //-- must be entered.

        elm.bind('keyup', function(event) {
          if (!scope.theField01.fieldDesc.fieldTypeIsNumber) return;
          var replacedValue;
          if (
            scope.theField01.fieldDesc.type != undefined &&
            (scope.theField01.fieldDesc.type.indexOf('.Double') != -1 ||
              scope.theField01.fieldDesc.type.indexOf('.Float') != -1)
          )
            replacedValue = event.target.value
              .replace(/[^\d\.]/g, '')
              .replace(/\./, 'x')
              .replace(/\./g, '')
              .replace(/x/, '.');
          else replacedValue = event.target.value.replace(/\D/g, '');
          //var replacedValue = event.target.value.replace(/\D/g, '');
          if (event.target.value !== replacedValue) {
            event.target.value = replacedValue;
          }
          try {
            scope.$apply();
          } catch(err) {}
        });
        elm.bind('keypress', function(event) {
          if (!scope.theField01.fieldDesc.fieldTypeIsNumber) return;
          event.keyCode = event.charCode || event.keyCode;
          //if (event.shiftKey || (event.keyCode < 48 || event.keyCode > 57) && event.keyCode !== 46 && event.keyCode !== 8 && event.keyCode !== 9 && event.keyCode !== 27 && event.keyCode !== 13 && event.keyCode !== 39 && event.keyCode !== 40 && !(event.keyCode === 65 && event.ctrlKey === true) && !(event.keyCode === 67 && event.ctrlKey === true) && !(event.keyCode === 80 && event.ctrlKey === true)) {
          if (
            (event.keyCode < 48 || event.keyCode > 57) &&
            event.keyCode !== 46 &&
            event.keyCode !== 8 &&
            event.keyCode !== 9 &&
            event.keyCode !== 27 &&
            event.keyCode !== 13 &&
            event.keyCode !== 39 &&
            event.keyCode !== 40 &&
            !(event.keyCode === 65 && event.ctrlKey === true) &&
            !(event.keyCode === 67 && event.ctrlKey === true) &&
            !(event.keyCode === 80 && event.ctrlKey === true)
          ) {
            event.preventDefault();
            try {
              scope.$apply();
            } catch(err) {}
          }
        });
        /*  */
      },
    };
  };

  FormFieldDirective.$inject = [];
  return FormFieldDirective;
});
