/**
 *
 */
'use strict';
define(function() {
  var FormFieldGroupCtrl = function(
    $scope,
    FeatureTypeFactory,
    GlobalServices,
    gaJsUtils
  ) {
    $scope.specificStepId = {};
    $scope.g2c_widname = 'ffgl2';
    $scope.fieldListIsBuilt = false;

    $scope.getConfigOfMoreInput = function(theField, fieldName) {
      var indCfg, len;

      //-- fieldName is like __moreInputs__0__
      //-- moreInputConfig is an array of configurations.
      if (theField.moreInputs != undefined) {
        //-- Calculate the length of the index
        len = 1;
        while (fieldName.substr(14 + len, 1) != '_') len++;
        //-- Get the index from the field name
        indCfg = parseInt(fieldName.substr(14, len));
        //-- If the index is in the bounds of the array, return the matching configuration.
        if (indCfg < theField.moreInputs.length)
          return theField.moreInputs[indCfg].moreInputConfig;
      }
      //-- Could not get the configuration so return NULL.
      return null;
    };

    $scope.getFieldDescription = function(theField, fieldDesc, ind1) {
      var indFD;

      for (indFD = 0; indFD < fieldDesc.length; indFD++) {
        if (theField.fieldDesc[indFD].name == theField.fieldOrder[ind1]) break;
      }
      return indFD;
    };

    $scope.getFieldValue = function(theField, ind1) {
      if (
        $scope.$parent.theStep != undefined &&
        $scope.$parent.theStep.objectFields != undefined
      )
        return $scope.$parent.theStep.objectFields[theField.fieldOrder[ind1]];
      else if (
        theField.objectFields == undefined ||
        theField.objectFields.length == 0 ||
        theField.objectFields[theField.fieldOrder[ind1]] == undefined
      ) {
        return '';
      } else return theField.objectFields[theField.fieldOrder[ind1]];
    };

    $scope.getMoreInputField = function(theField, ind1) {
      var newField = {};
      newField.field = theField.fieldOrder[ind1];
      newField.config = $scope.getConfigOfMoreInput(
        theField,
        theField.fieldOrder[ind1]
      );
      var ftDesc = FeatureTypeFactory.getFeatureTypeDesc(
        newField.config.datastoreName,
        newField.config.featureName
      );
      if (ftDesc != undefined) newField.relations = ftDesc.relations;
      if (theField.objectId != undefined) newField.objectId = theField.objectId;
      return newField;
    };

    $scope.getFieldRelationIndex = function(theField, ind1) {
      for (var ind = 0; ind < theField.relations.length; ind++) {
        if (theField.relations[ind].name == theField.fieldOrder[ind1])
          return ind;
      }
      return -1;
    };

    $scope.getRelationField = function(theField, ind1, indRel) {
      var ind3;
      var newField = {};

      newField.field = theField.fieldOrder[ind1];
      if ($scope.$parent.theStep != undefined)
        newField.datastoreName = $scope.$parent.theStep.fieldDesc.storeName;
      else
        newField.datastoreName =
          $scope.$parent.$parent.theField01.datastoreName;
      newField.relation = theField.relations[indRel];
      newField.fieldDesc = {};
      newField.fieldDesc.fieldTypeIsRelation = true;
      newField.fieldDesc.name = theField.fieldOrder[ind1];
      var relMainFields = theField.group.tableMainFields;
      for (ind3 = 0; ind3 < relMainFields.length; ind3++)
        if (relMainFields[ind3].table == newField.relation.componentEnd)
          newField.relatedObjectField = relMainFields[ind3].fields[0];
      /*
          if (panelFields[ind2].lineNumber==null)
              newField.lineNumber = 5;
          else
              newField.lineNumber = panelFields[ind2].lineNumber;
          if (panelFields[ind2].width==null)
              newField.width = "200px";
          else
              newField.width = panelFields[ind2].width;
          */
      // Store relation start field value in order to be able
      // to get objects already in relation with this one.
      if (
        $scope.$parent.theStep != undefined &&
        $scope.$parent.theStep.objectFields != undefined
      )
        if (
          newField.relation.occurence == 'N-M' ||
          newField.relation.fieldStart == 'id'
        )
          newField.objectId = $scope.$parent.theStep.objectId;
        else
          newField.objectId =
            $scope.$parent.theStep.objectFields[newField.relation.fieldStart];

      return newField;
    };

    /**
     *     Reset the field name in order it is correctly set when update to database is done.
     *  Now we set it to be the id field name which should look like id_xxx.
     *  This function is called when there is a relation with a selection form.
     *  In this case the property name of the object objectField has been
     *  set with the name of the relation.
     */
    $scope.setIdFieldNameForRelationWithForm = function(newField) {
      if (newField.objectField == undefined) newField.objectField = {};
      if (newField.relation.componentEnd == $scope.$parent.theStep.featureName)
        newField.objectField.name = newField.relation.fieldEnd;
      else newField.objectField.name = newField.relation.fieldStart;
    };

    $scope.setNewFieldSpecialDesc = function(newField, theField) {
      var fieldName;
      var sf = theField.group.specialFields;

      if (newField.fieldDesc != undefined) fieldName = newField.fieldDesc.name;
      if (
        fieldName != undefined &&
        sf != undefined &&
        sf[fieldName] != undefined
      ) {
        if (sf[fieldName].alias != undefined)
          newField.fieldDesc.alias = sf[fieldName].alias;
        if (
          sf[fieldName].selectWithForm != undefined &&
          newField.fieldDesc.fieldTypeIsRelation
        ) {
          newField.fieldDesc.fieldTypeIsRelationWithForm =
            sf[fieldName].selectWithForm;
          $scope.setIdFieldNameForRelationWithForm(newField);
        }
        if (sf[fieldName].configName != undefined)
          newField.configName = sf[fieldName].configName;
        if (sf[fieldName].storeAs != undefined)
          newField.storeAs = sf[fieldName].storeAs;
      }
    };

    $scope.setNewFieldpanelFieldsDesc = function(newField, theField) {
      if (theField.panelFields != undefined)
        for (var ind = 0; ind < theField.panelFields.length; ind++)
          if (theField.panelFields[ind].field == newField.fieldDesc.name) {
            newField.mode = theField.panelFields[ind].mode;
            break;
          }
    };

    $scope.enabledFields = function(theField) {
      $scope.fieldsAreEnabled = true;
      if (theField.enabled != undefined) {
        if (theField.enabled.type == 'fieldValue')
          if ($scope.$parent.getFieldValue != undefined)
            $scope.fieldsAreEnabled = $scope.$parent.getFieldValue(
              theField.enabled.fieldName
            );
      } else if ($scope.mode == 'readonly') $scope.fieldsAreEnabled = false;
    };

    /**
     *       Populate list of fields with enough configuration information
     *    to make them useable by the ffl2directive.
     *    The managed types of field are:
     *    - standard basic field (text, number, date,...)
     *    - relation field
     *    - specific field (configured as moreinput field in the configuration file)
     */
    $scope.buildFieldList = function() {
      var ind1, indFD, indRel;
      var fieldList = [];
      var theField, newField, fn;
      var fieldDesc, fieldValue;

      theField = $scope.$parent.theField;
      $scope.enabledFields(theField);

      fieldDesc = theField.fieldDesc;
      if (
        $scope.$parent.theStep != undefined &&
        $scope.$parent.theStep.objectId != undefined
      ) {
        $scope.specificStepId.value = $scope.$parent.theStep.objectId;
        $scope.specificStepId.table = $scope.$parent.theStep.featureName;
      }
      for (ind1 = 0; ind1 < theField.fieldOrder.length; ind1++) {
        //-- Get field description
        indFD = $scope.getFieldDescription(theField, fieldDesc, ind1);
        fn = theField.fieldOrder[ind1];
        //-- Get field value
        newField = undefined;
        if (indFD < theField.fieldDesc.length) {
          newField = {
            objectField: {
              name: fn,
              value: $scope.getFieldValue(theField, ind1),
            },
            fieldDesc: theField.fieldDesc[indFD],
          };
        } else if (
          theField.fieldOrder[ind1].substr(0, 14) == '__moreInputs__'
        ) {
          newField = $scope.getMoreInputField(theField, ind1);
        } else {
          indRel = $scope.getFieldRelationIndex(theField, ind1);
          if (indRel != -1)
            newField = $scope.getRelationField(theField, ind1, indRel);
        }
        if (newField != undefined) {
          $scope.setNewFieldpanelFieldsDesc(newField, theField);
          $scope.setNewFieldSpecialDesc(newField, theField);
          if (!$scope.fieldsAreEnabled) newField.disabledFromParent = true;
          if (theField.mode != undefined && theField.mode == 'readonly')
            newField.mode = 'readonly';
          if (
            theField.group.readonlyFields != undefined &&
            theField.group.readonlyFields.indexOf(fn) != -1
          )
            newField.mode = 'readonly';
          fieldList.push(newField);
        }
      }

      //-- Is there a special input configured ?
      if (theField.moreInputs != undefined)
        for (ind1 = 0; ind1 < theField.moreInputs.length; ind1++) {
          if (
            theField.moreInputs[ind1].moreInputConfig.contentType ==
            'indicateurmgt'
          ) {
            $scope.indicateurMgt = true;
            $scope.indicConfig = theField.moreInputs[ind1].moreInputConfig;
          }
        }

      $scope.state = 'open';
      $scope.fields = fieldList;
      $scope.title = theField.title;
      $scope.fieldListIsBuilt = true;
    };

    $scope.valueChangedFunction = true;
    $scope.valueChanged = function(param) {
      var ind,
        ret = {};

      for (ind = 0; ind < $scope.fields.length; ind++) {
        if ($scope.fields[ind].objectField != undefined)
          $scope.$parent.theField.objectFields[
            $scope.fields[ind].objectField.name
          ] = $scope.fields[ind].objectField.value;
      }

      if (
        !GlobalServices.controlsOk(
          $scope.theField.objectFields,
          $scope.theField.group,
          ret
        )
      ) {
        gaJsUtils.errorMessage('Valeur incorrecte non prise en compte !');
        for (ind = 0; ind < $scope.fields.length; ind++) {
          if ($scope.fields[ind].objectField.name == ret.nameOfWrongAttribute) {
            $scope.fields[ind].objectField.value =
              $scope.$parent.theField.objectFields[ret.nameOfWrongAttribute];
            break;
          }
        }
      }

      if ($scope.$parent.valueChangedFunction === true) {
        $scope.$parent.valueChanged(param);
      }
    };

    /*---------------------------------------------------------*/
    /*-------------------     EVENTS      ---------------------*/

    /**
     *       When there is a change in a child list of from ftable4updl2.
     *   So we inform all the children of this change in case they have to react.
     *   The param dat contains the concerned feature type name
     *   (the table listed in the fftable4updl2).
     */
    $scope.$on('childListChanged', function(event, data) {
      $scope.$broadcast('brotherListChanged', data);
    });

    if ($scope.$parent.theField.objectFields.length == 0) {
      $scope.$on('gotRelatedObjects11ou1N', function(event, data) {
        if (
          !$scope.fieldListIsBuilt &&
          $scope.$parent.theField.objectFields.length != 0
        )
          $scope.buildFieldList();
      });
      $scope.$on('gotRelatedObjects', function(event, data) {
        var fn, val;

        if (
          !$scope.fieldListIsBuilt &&
          $scope.$parent.theField.objectFields.length != 0
        )
          $scope.buildFieldList();
        for (var ind = 0; ind < $scope.fields.length; ind++) {
          //-- fieldDesc may be undefined when field is a moreInputField
          if ($scope.fields[ind].fieldDesc != undefined) {
            fn = $scope.fields[ind].fieldDesc.name;
            val = data.objects.features[0].properties[fn];
            if (val != undefined) $scope.fields[ind].objectField.value = val;
          }
        }
      });
    }

    $scope.$on('changeEmittedToParent', function(event, data) {
      $scope.$broadcast('oneFieldHasChanged', data);
    });

    /*-------------------     ------      ---------------------*/

    $scope.buildFieldList();
  };

  FormFieldGroupCtrl.$inject = [
    '$scope',
    'FeatureTypeFactory',
    'GlobalServices',
    'gaJsUtils',
  ];
  return FormFieldGroupCtrl;
});
