'use strict';
define(function() {
  var gcelement = function(FeatureTypeFactory, AepAppFactory) {
    return {
      templateUrl: 'js/XG/biz/aep/views/dossiers.html',
      restrict: 'A',

      scope: {
        map: '=map',
      },
      controller: [
        '$scope',
        '$element',
        '$attrs',
        function($scope, $element, $attrs) {
          $scope.ftis = {};
          $scope.mavariable = 'mavariable';
          // A mettre dans la config
          //
          $scope.ftis['anomalie'] = FeatureTypeFactory.getFeatureByUid(
            '88058ca7-804a-4ab9-8a28-dc983c7815b9'
          );
          $scope.ftis['emmeteur'] = FeatureTypeFactory.getFeatureByUid(
            'c1493ef9-1305-4639-ba61-5bb748eeb2a0'
          );
          $scope.ftis['agents'] = FeatureTypeFactory.getFeatureByUid(
            '05f24131-36ce-45a4-919d-43169b3e3ade'
          );
          $scope.ftis[
            'int_recherche_fuite'
          ] = FeatureTypeFactory.getFeatureByUid(
            '62ae210e-1687-40ad-a746-c5d71b6b2ca0'
          );
          $scope.res = {};
          $scope.res['anomalie'] = {};
          $scope.res['anomalie'].ftid = '88058ca7-804a-4ab9-8a28-dc983c7815b9';
          $scope.res['anomalie'].data = {};
          $scope.res['emmeteur'] = {};
          $scope.res['emmeteur'].ftid = 'c1493ef9-1305-4639-ba61-5bb748eeb2a0';
          $scope.res['emmeteur'].data = {};
          $scope.res['agents'] = {};
          $scope.res['agents'].ftid = '05f24131-36ce-45a4-919d-43169b3e3ade';
          $scope.res['agents'].data = {};
          $scope.feattree = {};
          // data de l'arbre
          $scope.featdata = [
            {
              label: 'Anomalies',
              template: '',
              children: [
                {
                  label: 'Incident/Anomalie',
                  template:
                    'js/XG/biz/aep/views/anomalies/incidentanomalie.html',
                },
                {
                  label: 'Emetteur',
                  template: 'js/XG/biz/aep/views/anomalies/emetteur.html',
                },
                {
                  label: 'Suite à Donner',
                  template: 'js/XG/biz/aep/views/anomalies/suite.html',
                },
              ],
            },
            {
              label: 'Interventions',
              template: '',
              children: [
                {
                  label: 'Info. Generales',
                  template:
                    'js/XG/biz/aep/views/interventions/info_generales.html',
                },
                {
                  label: 'Recherche de fuite',
                  template:
                    'js/XG/biz/aep/views/interventions/info_generales.html',
                  children: [
                    {
                      label: 'Descriptif',
                      template:
                        'js/XG/biz/aep/views/interventions/descriptif_rf.html',
                    },
                  ],
                },
                {
                  label: 'Reparation de fuite',
                  template:
                    'js/XG/biz/aep/views/interventions/info_generales.html',
                  children: [
                    {
                      label: 'Descriptif',
                      template:
                        'js/XG/biz/aep/views/interventions/descriptif_rpf.html',
                    },
                    {
                      label: 'Robinetterie',
                      template:
                        'js/XG/biz/aep/views/interventions/descriptif_rpf_robi.html',
                    },

                    {
                      label: 'Fontainerie',
                      template:
                        'js/XG/biz/aep/views/interventions/descriptif_rpf_font.html',
                    },
                    {
                      label: 'Branchement',
                      template:
                        'js/XG/biz/aep/views/interventions/descriptif_rpf_branchement.html',
                    },
                    {
                      label: 'Canalisation',
                      template: '',
                      children: [
                        {
                          label: 'Generale',
                          template:
                            'js/XG/biz/aep/views/interventions/ouvrages/generale.html',
                        },
                        {
                          label: 'Intervention',
                          template:
                            'js/XG/biz/aep/views/interventions/ouvrages/interventions.html',
                        },
                        {
                          label: 'Conduite et environnement',
                          template:
                            'js/XG/biz/aep/views/interventions/ouvrages/conduite.html',
                        },
                        {
                          label: 'Etat Interne',
                          template:
                            'js/XG/biz/aep/views/interventions/ouvrages/etat_interne.html',
                        },

                        {
                          label: 'Etat Externe',
                          template:
                            'js/XG/biz/aep/views/interventions/ouvrages/etat_externe.html',
                        },
                      ],
                    },
                  ],
                },
                {
                  label: 'Reparation sur ouvrage',
                  template:
                    'js/XG/biz/aep/views/interventions/info_generales.html',
                  children: [
                    {
                      label: 'Descriptif',
                      template:
                        'js/XG/biz/aep/views/interventions/descriptif_repouvrage.html',
                    },
                  ],
                },
                {
                  label: 'Autre',
                  template:
                    'js/XG/biz/aep/views/interventions/info_generales.html',
                  children: [
                    {
                      label: 'Descriptif',
                      template:
                        'js/XG/biz/aep/views/interventions/descriptif_autre.html',
                    },
                  ],
                },
                {
                  label: 'Interv. Abonné',
                  template:
                    'js/XG/biz/aep/views/interventions/info_generales.html',
                  children: [
                    {
                      label: 'Descriptif',
                      template:
                        'js/XG/biz/aep/views/interventions/descriptif_abonne.html',
                    },
                  ],
                },
              ],
            },
            {
              label: 'Documents associés',
              template: 'js/XG/biz/aep/views/anomalies/document_associes.html',
            },
          ];
          $scope.selectedIcon = '';

          $scope.icons = [
            { value: 'Gear', label: '<i class="fa fa-gear"></i> Gear' },
            {
              value: 'Globe',
              label: '<i class="fa fa-globe"></i> Globe',
            },
            {
              value: 'Heart',
              label: '<i class="fa fa-heart"></i> Heart',
            },
            {
              value: 'Camera',
              label: '<i class="fa fa-camera"></i> Camera',
            },
          ];

          //$scope.ftis['interventions'] = FeatureTypeFactory.getFeatureByUid('9950e04c-2840-4607-93b8-0ddd6b4b34a6');
        },
      ],
      link: function(scope, element, attrs, ctrl) {
        /*scope.variable ="toto";
             scope.$watch("variable", function(newValue, oldValue) {
                      console.log(newValue);
                      console.log(oldValue);
                      ApiFuction.RunMethods(variable, map)
                    }
            ); */

        scope.curtemplate = '';
        scope.tree_handler = function(branch) {
          scope.curtemplate = branch.template;
          console.log(branch);
          AepAppFactory.updatedossier(scope.res).then(function(data) {
            console.log(data.data);
          });
        };
      },
    };
  };

  gcelement.$inject = ['FeatureTypeFactory', 'AepAppFactory'];
  return gcelement;
});
